package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.integration.IntegrationHelper;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

public class AdvertAdaptersupersonic extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdaptersupersonic] ";
    private static final String CHANNEL_CODE = "Supersonic";

    private static final String KEY_SUPERSONIC_APP_ID = "ad_supersonic_app_id";

    RewardedVideoListener rewardedVideoListener = new RewardedVideoListener() {

        @Override
        public void onRewardedVideoAdClosed() {
            // called when the video is closed
            YLog.d(TAG + "onRewardedVideoAdClosed");
            // here we show a dialog to the user if he was rewarded
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAvailabilityChanged(boolean available) {
            YLog.d(TAG + "onRewardedVideoAvailabilityChanged, available: " + available);
            if (getReloadVideoCallback() != null && available) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdStarted() {
            YLog.d(TAG + "onRewardedVideoAdStarted");
        }

        @Override
        public void onRewardedVideoAdEnded() {
            YLog.d(TAG + "onRewardedVideoAdEnded");
        }

        @Override
        public void onRewardedVideoAdShowFailed(IronSourceError ironSourceError) {
            YLog.d(TAG + "onRewardedVideoAdShowFailed, error code: " + ironSourceError.getErrorCode() + ", error message: " + ironSourceError.getErrorMessage());
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), getAdvertCode());
            }
            if (getVideoCallback() != null) {
                getVideoCallback().onAdError(Yodo1AdConst.ADVERT_ERROR_DISPLAY_FAILED, ironSourceError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdClicked(Placement placement) {
            YLog.d(TAG + "onRewardedVideoAdClicked");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdOpened() {
            YLog.d(TAG + "onRewardedVideoAdOpened");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdRewarded(Placement placement) {
            // called when the video has been rewarded and a reward can be given to the user
            String rewardName = placement.getRewardName();
            int rewardAmount = placement.getRewardAmount();
            YLog.d(TAG + "onRewardedVideoAdRewarded, rewardName: " + rewardName + ", rewardAmount: " + rewardAmount);

            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

    };

    InterstitialListener interstitialListener = new InterstitialListener() {
        @Override
        public void onInterstitialAdReady() {
            YLog.d(TAG + "onInterstitialAdReady");
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdLoadFailed(IronSourceError ironSourceError) {
            YLog.d(TAG + "onInterstitialAdLoadFailed, error code: " + ironSourceError.getErrorCode() + ", error message: " + ironSourceError.getErrorMessage());
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdOpened() {
            YLog.d(TAG + "onInterstitialAdOpened");
        }

        @Override
        public void onInterstitialAdClosed() {
            YLog.d(TAG + "onInterstitialAdClosed");

            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdShowSucceeded() {
            YLog.d(TAG + "onInterstitialAdShowSucceeded");

            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdShowFailed(IronSourceError ironSourceError) {
            YLog.d(TAG + "onInterstitialAdShowFailed, error code: " + ironSourceError.getErrorCode() + ", error message: " + ironSourceError.getErrorMessage());
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onAdError(Yodo1AdConst.ADVERT_ERROR_DISPLAY_FAILED, ironSourceError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdClicked() {
            YLog.d(TAG + "onInterstitialAdClicked");
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }


    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
        if (!this.isInitialized()) {
            return;
        }
        IronSource.onResume(activity);
    }

    @Override
    public void onPause(Activity activity) {
        if (!this.isInitialized()) {
            return;
        }
        IronSource.onPause(activity);
    }

    @Override
    public void onDestroy(Activity activity) {
    }

    @Override
    public void initSdk(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        String appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_SUPERSONIC_APP_ID);
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_SUPERSONIC_APP_ID);
        }

        if (TextUtils.isEmpty(appId)) {
            YLog.i(TAG + "Initialize sdk failure, appId: " + appId);
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "appId is null", getAdvertCode());
            return;
        }

        IronSource.init(activity, appId);
        IntegrationHelper.validateIntegration(activity);

        if (getPrivacy() != null) {
            IronSource.setConsent(getPrivacy().isHasUserConsent());
        }

        this.setInitialized(true);
        YLog.d(TAG + "Initialize sdk successful, appId: " + appId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }
        IronSource.setRewardedVideoListener(rewardedVideoListener);

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful");

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }


    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setVideoCallback(callback);
        YLog.d(TAG + "Showing rewarded video ad...");

        boolean isRewardedVideoAvailable = videoAdvertIsLoaded(activity);
        if (isRewardedVideoAvailable) {
            //show rewarded video
            IronSource.showRewardedVideo();
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return IronSource.isRewardedVideoAvailable();
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }
        IronSource.setInterstitialListener(interstitialListener);

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial video ad successful");

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setIntersititalCallback(callback);

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                boolean isInterstitialReady = interstitialAdvertIsLoaded(activity);
                YLog.d(TAG + "Showing interstitial video ad...");

                if (isInterstitialReady) {
                    //show the interstitial
                    IronSource.showInterstitial();
                }
            }
        });

    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        YLog.d(TAG + "Loading interstitial video ad...");

        if (!interstitialAdvertIsLoaded(activity)) {
            IronSource.loadInterstitial();
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return IronSource.isInterstitialReady();
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        super.setPrivacy(privacy, context);
        YLog.d(TAG + "Set privacy, consent: " + privacy.isHasUserConsent());
    }
}
