package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.chartboost.sdk.CBLocation;
import com.chartboost.sdk.Chartboost;
import com.chartboost.sdk.ChartboostDelegate;
import com.chartboost.sdk.Libraries.CBLogging;
import com.chartboost.sdk.Model.CBError;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

public class AdvertAdapterchartboost extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdapterchartboost] ";
    private static final String CHANNEL_CODE = "Chartboost";

    private static final String KEY_CHARTBOOST_APP_ID = "ad_chartboost_app_id";
    private static final String KEY_CHARTBOOST_SIGNATURE_ID = "ad_chartboost_signature_id";

    ChartboostDelegate delegate = new ChartboostDelegate() {

        @Override
        public boolean shouldRequestInterstitial(String location) {
            YLog.d(TAG + "shouldRequestInterstitial, location = " + location);
            return true;
        }

        @Override
        public boolean shouldDisplayInterstitial(String location) {
            YLog.d(TAG + "shouldDisplayInterstitial, location = " + location);
            return true;
        }

        @Override
        public void didCacheInterstitial(String location) {
            YLog.d(TAG + "didCacheInterstitial, location = " + location);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void didFailToLoadInterstitial(String location, CBError.CBImpressionError error) {
            YLog.d(TAG + "didFailToLoadInterstitial, location = " + error.toString());
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, error.name(), getAdvertCode());
            }
        }

        @Override
        public void didDismissInterstitial(String location) {
            YLog.d(TAG + "didDismissInterstitial, location = " + location);
        }

        @Override
        public void didCloseInterstitial(String location) {
            YLog.d(TAG + "didCloseInterstitial, location = " + location);
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void didClickInterstitial(String location) {
            YLog.d(TAG + "didClickInterstitial, location = " + location);
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void didDisplayInterstitial(String location) {
            YLog.d(TAG + "didDisplayInterstitial, location = " + location);
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }


        @Override
        public void didFailToRecordClick(String uri, CBError.CBClickError error) {
            YLog.d(TAG + "didFailToRecordClick, error = " + error + ", uri = " + uri);
        }

        @Override
        public boolean shouldDisplayRewardedVideo(String location) {
            YLog.d(TAG + "shouldDisplayRewardedVideo, location = " + location);
            return true;
        }

        @Override
        public void didCacheRewardedVideo(String location) {
            YLog.d(TAG + "didCacheRewardedVideo, location = " + location);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void didFailToLoadRewardedVideo(String location, CBError.CBImpressionError error) {
            YLog.d(TAG + "didFailToLoadRewardedVideo, location = " + location + ", error = " + error);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, error.name(), getAdvertCode());
            }
        }

        @Override
        public void didDismissRewardedVideo(String location) {
            YLog.d(TAG + "didDismissRewardedVideo, location = " + location);
        }

        @Override
        public void didCloseRewardedVideo(String location) {
            YLog.d(TAG + "didCloseRewardedVideo, location = " + location);
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

        }

        @Override
        public void didClickRewardedVideo(String location) {
            YLog.d(TAG + "didClickRewardedVideo, location = " + location);
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }

        }

        @Override
        public void didCompleteRewardedVideo(String location, int reward) {
            YLog.d(TAG + "didCompleteRewardedVideo, location = " + location + ", reward = " + reward);
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }

        }

        @Override
        public void didDisplayRewardedVideo(String location) {
            YLog.d(TAG + "didDisplayRewardedVideo, location = " + location);
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }

        }

        @Override
        public void willDisplayVideo(String location) {
            YLog.d(TAG + "willDisplayVideo, location = " + location);
        }

    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return Chartboost.getSDKVersion();
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
        if (!this.isInitialized()) {
            return;
        }

        Chartboost.onStart(activity);
        Chartboost.onResume(activity);
    }

    @Override
    public void onPause(Activity activity) {
        if (!this.isInitialized()) {
            return;
        }
        Chartboost.onPause(activity);
        Chartboost.onStop(activity);
    }


    @Override
    public void onDestroy(Activity activity) {
        if (!this.isInitialized()) {
            return;
        }
        Chartboost.onDestroy(activity);
    }

    @Override
    public void initSdk(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (this.isInitialized() || activity == null || initializeCallback == null) {
            return;
        }

        String appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_CHARTBOOST_APP_ID);
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_CHARTBOOST_APP_ID);
        }
        String signatureId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_CHARTBOOST_SIGNATURE_ID);
        if (TextUtils.isEmpty(signatureId)) {
            signatureId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_CHARTBOOST_SIGNATURE_ID);
        }
        if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(signatureId)) {
            YLog.d(TAG + "Initialize sdk  failure, appId or signatureId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "appId or signatureId is null", getAdvertCode());
            return;
        }

        Chartboost.startWithAppId(activity, appId, signatureId);
        Chartboost.setLoggingLevel(CBLogging.Level.ALL);
        Chartboost.setActivityAttrs(activity);
        Chartboost.onCreate(activity);
        Chartboost.onStart(activity);
        Chartboost.onResume(activity);
        Chartboost.setAutoCacheAds(true);
        Chartboost.setDelegate(delegate);

        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            Chartboost.CBPIDataUseConsent consent = privacy.isHasUserConsent() ? Chartboost.CBPIDataUseConsent.YES_BEHAVIORAL : Chartboost.CBPIDataUseConsent.NO_BEHAVIORAL;
            Chartboost.setPIDataUseConsent(activity, consent);
        }

        this.setInitialized(true);
        YLog.d(TAG + "Initialize sdk successful, " + "appId: " + appId + ", signatureId: " + signatureId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }
        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial video ad successful");

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setIntersititalCallback(callback);
        YLog.d(TAG + "Showing interstitial video ad...");

        if (interstitialAdvertIsLoaded(activity)) {
            Chartboost.showInterstitial(CBLocation.LOCATION_LEADERBOARD);
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        YLog.d(TAG + "Loading interstitial video ad...");

        Chartboost.cacheInterstitial(CBLocation.LOCATION_LEADERBOARD);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return Chartboost.hasInterstitial(CBLocation.LOCATION_LEADERBOARD);
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }
        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful");

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setVideoCallback(callback);
        YLog.d(TAG + "Showing rewarded video ad...");

        if (videoAdvertIsLoaded(activity)) {
            Chartboost.showRewardedVideo(CBLocation.LOCATION_DEFAULT);
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad...");

        Chartboost.cacheRewardedVideo(CBLocation.LOCATION_DEFAULT);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return Chartboost.hasRewardedVideo(CBLocation.LOCATION_DEFAULT);
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        super.setPrivacy(privacy, context);
        YLog.d(TAG + "Set privacy, consent: " + privacy.isHasUserConsent() + ", is child: " + privacy.isAgeRestrictedUser());
    }
}
