package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.mintegral.msdk.MIntegralSDK;
import com.mintegral.msdk.interstitialvideo.out.InterstitialVideoListener;
import com.mintegral.msdk.interstitialvideo.out.MTGInterstitialVideoHandler;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.MTGRewardVideoHandler;
import com.mintegral.msdk.out.RewardVideoListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

import java.util.Map;


/**
 * Created by yodo1 on 2017/9/27.
 */
public class AdvertAdaptermintegral_gp extends AdapterAdvertBase {
    private static final String CHANNEL_CODE = "mintegral_gp";

    private static final String KEY_MINTEGRAL_APP_ID = "ad_mintegral_gp_appid";
    private static final String KEY_MINTEGRAL_APP_KEY = "ad_mintegral_gp_appkey";

    private static final String KEY_MINTEGRAL_RewardUnitId = "ad_mintegral_gp_rewardUnitId";
    private static final String KEY_MINTEGRAL_InterstitialUnitId = "ad_mintegral_gp_interstitialUnitId";

    private String appId, appKey, interUnitId, videoUnitId;

    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;
    private MTGRewardVideoHandler mMvRewardVideoHandler;

    private MTGInterstitialVideoHandler mMtgInterstitalVideoHandler;
    private InterstitialVideoListener interstitialVideoListener = new InterstitialVideoListener() {

        @Override
        public void onLoadSuccess(String s) {
            YLog.d(CHANNEL_CODE + " InterstitialVideo onLoadSuccess");
        }

        @Override
        public void onVideoLoadSuccess(String s) {
            YLog.d(CHANNEL_CODE + " InterstitialVideo onVideoLoadSuccess");
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onVideoLoadFail(String s) {
            YLog.d(CHANNEL_CODE + " InterstitialVideo onInterstitialVideoLoadFail, message: " + s);
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, s, getAdvertCode());
            }
        }

        @Override
        public void onShowFail(String errorMsg) {
            YLog.d(CHANNEL_CODE + " InterstitialVideo onShowFail, message: " + errorMsg);
            if (intersititalCallback != null) {
                intersititalCallback.onAdError(Yodo1AdConst.ADVERT_EVENT_CLOSE, errorMsg, getAdvertCode());
            }
        }

        @Override
        public void onAdShow() {
            YLog.d(CHANNEL_CODE + " InterstitialVideo onAdShow");
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdClose(boolean isCompleteView) {
            YLog.d(CHANNEL_CODE + " InterstitialVideo onAdClose, isCompleteView: " + isCompleteView);

            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }


        @Override
        public void onVideoAdClicked(String unitId) {
            YLog.d(CHANNEL_CODE + " InterstitialVideo onVideoAdClicked");
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onVideoComplete(String s) {
            YLog.d(CHANNEL_CODE + " InterstitialVideo onVideoComplete");
        }

        @Override
        public void onEndcardShow(String s) {
            YLog.d(CHANNEL_CODE + " InterstitialVideo onEndcardShow");
        }

    };
    private RewardVideoListener rewardVideoListener = new RewardVideoListener() {

        @Override
        public void onVideoLoadSuccess(String s) {
            YLog.d(CHANNEL_CODE + " RewardVideo onVideoLoadSuccess");
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onLoadSuccess(String s) {
            YLog.d(CHANNEL_CODE + " RewardVideo onLoadSuccess");
        }

        @Override
        public void onVideoLoadFail(String s) {
            YLog.d(CHANNEL_CODE + " RewardVideo onVideoLoadFail, message: " + s);
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, s, getAdvertCode());
            }
        }

        @Override
        public void onShowFail(String errorMsg) {
            YLog.d(CHANNEL_CODE + " RewardVideo onShowFail, message: " + errorMsg);
            if (videoCallback != null) {
                videoCallback.onAdError(Yodo1AdConst.ADVERT_EVENT_CLOSE, errorMsg, getAdvertCode());
            }
        }

        @Override
        public void onAdShow() {
            YLog.d(CHANNEL_CODE + " RewardVideo onAdShow");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdClose(boolean isCompleteView, String RewardName, float RewardAmout) {
            YLog.d(CHANNEL_CODE + " RewardVideo onAdClose, isCompleteView:" + isCompleteView + ", RewardName: " + RewardName + ", RewardAmout: " + RewardAmout);

            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onVideoAdClicked(String unitId) {
            YLog.d(CHANNEL_CODE + " RewardVideo onVideoAdClicked");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onVideoComplete(String s) {
            YLog.d(CHANNEL_CODE + " RewardVideo onVideoComplete, message: " + s);
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onEndcardShow(String s) {
            YLog.d(CHANNEL_CODE + " RewardVideo onEndcardShow");
        }

    };
    private Yodo1Privacy privacy;

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        YLog.d(CHANNEL_CODE + " showIntersititalAdvert...");
        if (mMtgInterstitalVideoHandler == null) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "uninitialized", getAdvertCode());
            return;
        }
        if (mMtgInterstitalVideoHandler.isReady()) {
            mMtgInterstitalVideoHandler.show();
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        YLog.d(CHANNEL_CODE + " reloadInterstitialAdvert...");
        this.reloadInterCallback = callback;

        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, callback, null)) {
            return;
        }

        if (mMtgInterstitalVideoHandler == null) {
            callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_COMMON, 0, "uninitialized", getAdvertCode());
            return;
        }
        mMtgInterstitalVideoHandler.load();
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return mMtgInterstitalVideoHandler.isReady();
    }

    public void validateAdsAdapter(Activity activity) {

    }

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_MINTEGRAL_APP_ID);
        appKey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_MINTEGRAL_APP_KEY);

        if (TextUtils.isEmpty(appId) && TextUtils.isEmpty(appKey)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_MINTEGRAL_APP_ID);
            appKey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_MINTEGRAL_APP_KEY);
        }

//            MIntegralConstans.DEBUG = true;
        if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(appKey)) {
            YLog.d(CHANNEL_CODE + " AppID or AppKey is null");
            return;
        }
        YLog.d(CHANNEL_CODE + " AppID:  " + appId + ", AppKey: " + appKey);

        MIntegralSDK sdk = MIntegralSDKFactory.getMIntegralSDK();
        // test appId and appKey

        if (privacy != null && privacy.isHasUserConsent()) {
            sdk.setUserPrivateInfoType(activity, "authority_all_info", 1);
            sdk.setConsentStatus(activity, 1);
        }
        Map<String, String> map = sdk.getMTGConfigurationMap(appId, appKey);

        // if you modify applicationId, please add the following attributes,
        // otherwise it will crash
        // map.put(MobVistaConstans.PACKAGE_NAME_MANIFEST, "your AndroidManifest
        // package value");
        sdk.init(map, activity.getApplication());
    }

    @Override
    public void initInterstitialAd(Activity activity) {
        interUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_MINTEGRAL_InterstitialUnitId);

        if (TextUtils.isEmpty(interUnitId)) {
            YLog.d(CHANNEL_CODE + " interUnitId is null");
            return;
        }
        YLog.d(CHANNEL_CODE + " interUnitId :  " + interUnitId);
        mMtgInterstitalVideoHandler = new MTGInterstitialVideoHandler(activity, interUnitId);
        mMtgInterstitalVideoHandler.setInterstitialVideoListener(interstitialVideoListener);

    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        YLog.d(CHANNEL_CODE + " showVideoAdvert...");
        if (mMvRewardVideoHandler == null) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "uninitialized", getAdvertCode());
            return;
        }
        if (mMvRewardVideoHandler.isReady()) {
            mMvRewardVideoHandler.show("1");
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        YLog.d(CHANNEL_CODE + " reloadVideoAdvert...");
        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null)) {
            return;
        }

        if (mMvRewardVideoHandler == null) {
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_COMMON, 0, "uninitialized", getAdvertCode());
            return;
        }
        mMvRewardVideoHandler.load();
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return mMvRewardVideoHandler != null && mMvRewardVideoHandler.isReady();
    }

    @Override
    public void initVideoAd(Activity activity) {
        videoUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_MINTEGRAL_RewardUnitId);
//        RewardUnitId = "58394";
        if (TextUtils.isEmpty(videoUnitId)) {
            YLog.d(CHANNEL_CODE + " videoUnitId is null");
            return;
        }
        YLog.d(CHANNEL_CODE + " videoUnitId :  " + videoUnitId);
        mMvRewardVideoHandler = new MTGRewardVideoHandler(activity, videoUnitId);
        mMvRewardVideoHandler.setRewardVideoListener(rewardVideoListener);
    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        this.privacy = privacy;
    }

    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd) {
            if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(appKey) || TextUtils.isEmpty(interUnitId)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd) {
            if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(appKey) || TextUtils.isEmpty(videoUnitId)) {
                isValid = false;
            }
        }

        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_ID_NULL, "", getAdvertCode());
            }
        }

        return isValid;
    }
}
