/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.sdk.kit;

import android.content.Context;
import android.text.TextUtils;
import com.yodo1.sdk.kit.RR;
import com.yodo1.sdk.kit.YLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Yodo1PropertiesUtils {
    public static final String FILE_NAME_PROPERTIES = "yodo1_games_config";
    private static Yodo1PropertiesUtils mInstance;
    private Properties mBasicConfig;
    private Properties mBasicConfig_assets;

    private Yodo1PropertiesUtils() {
    }

    public static Yodo1PropertiesUtils getInstance() {
        if (mInstance == null) {
            mInstance = new Yodo1PropertiesUtils();
        }
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromRaw(Context context, int rawResId) {
        Properties properties = null;
        InputStream inputStream = null;
        try {
            if (rawResId > 0) {
                properties = new Properties();
                inputStream = context.getResources().openRawResource(rawResId);
                properties.load(inputStream);
            } else {
                YLog.d("res not found : " + rawResId);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            YLog.d("getPropertiesFromRaw failed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromAssets(Context context, String fileName) {
        Properties properties = null;
        InputStream inputStream = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)fileName)) {
                properties = new Properties();
                inputStream = context.getAssets().open(fileName);
                properties.load(inputStream);
            } else {
                YLog.d("filePath is null : ");
            }
        }
        catch (Exception e) {
            YLog.d("getProperties failed : " + fileName);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return properties;
    }

    public void initProperties(Context context) {
        if (this.mBasicConfig == null) {
            int resId = RR.raw(context, FILE_NAME_PROPERTIES);
            if (resId > 0) {
                this.mBasicConfig = Yodo1PropertiesUtils.getPropertiesFromRaw(context, resId);
            } else {
                YLog.d("yodo1properties file is not find, filename : yodo1_games_config");
            }
        }
    }

    public String getBasicConfigValue(String key) {
        if (this.mBasicConfig == null) {
            YLog.d("get error, yodo1properties is not init ...");
            return null;
        }
        String parameter = this.mBasicConfig.getProperty(key);
        if (TextUtils.isEmpty((CharSequence)parameter)) {
            YLog.d("yodo1properties, property not found : " + key);
        }
        return parameter;
    }

    public boolean putBasicConfigValue(String key, String value) {
        if (this.mBasicConfig == null) {
            YLog.d("put error, yodo1properties is not init ...");
            return false;
        }
        this.mBasicConfig.put(key, value);
        return true;
    }

    public String getBasicConfigValueFromAssets(Context context, String fileName, String key) {
        String parameter;
        if (this.mBasicConfig_assets == null) {
            this.mBasicConfig_assets = Yodo1PropertiesUtils.getPropertiesFromAssets(context, fileName);
        }
        if (TextUtils.isEmpty((CharSequence)(parameter = this.mBasicConfig_assets.getProperty(key)))) {
            YLog.d("yodo1properties, property not found : " + key);
        }
        return parameter;
    }
}

