/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.sdk.kit;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.yodo1.sdk.kit.YLog;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class Yodo1OperatorUtils {
    public static final int CHANNEL_ID_default = 0;
    public static final int CHANNEL_ID_cmcc = 1;
    public static final int CHANNEL_ID_telecom = 2;
    public static final int CHANNEL_ID_unicom = 4;
    private static final String TAG = "Yodo1OperatorUtils";
    private static TelephonyManager telephonyManager;
    private static String IMSI;

    public static String getProvidersName(Context context) {
        String nop = null;
        telephonyManager = (TelephonyManager)context.getSystemService("phone");
        IMSI = telephonyManager.getSubscriberId();
        Log.i((String)TAG, (String)("IMSI == " + IMSI));
        if (IMSI == null || IMSI.length() < 1 || telephonyManager.getSimState() == 1) {
            return nop;
        }
        nop = IMSI.substring(0, 5);
        return nop;
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static int getOperatorType(Context context) {
        if (Yodo1OperatorUtils.isTablet(context)) {
            return 0;
        }
        TelephonyManager phoneManager = (TelephonyManager)context.getSystemService("phone");
        String operator = phoneManager.getSubscriberId();
        if (operator == null || operator.length() < 1 || phoneManager.getSimState() == 1) {
            return 0;
        }
        if (operator.startsWith("46000") || operator.startsWith("46002") || operator.startsWith("46007") || operator.startsWith("46020")) {
            return 1;
        }
        if (operator.startsWith("46001") || operator.startsWith("46006")) {
            return 4;
        }
        if (operator.startsWith("46003") || operator.startsWith("46005") || operator.startsWith("46011")) {
            return 2;
        }
        return 0;
    }

    public static String getNetWorkType(Context context) {
        String mNetWorkType = "";
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            String type = networkInfo.getTypeName();
            if (type.equalsIgnoreCase("WIFI")) {
                mNetWorkType = "wifi";
            } else if (type.equalsIgnoreCase("MOBILE")) {
                String proxyHost = Proxy.getDefaultHost();
                mNetWorkType = TextUtils.isEmpty((CharSequence)proxyHost) ? (Yodo1OperatorUtils.isFastMobileNetwork(context) ? "3g" : "2g") : "wap";
            }
        } else {
            mNetWorkType = "NETWORKTYPE_INVALID";
        }
        return mNetWorkType;
    }

    public static int getNetworkType(Context context) {
        String net;
        int mNetWorkType = 0;
        switch (net = Yodo1OperatorUtils.getNetWorkType(context)) {
            case "wifi": {
                mNetWorkType = 100;
                break;
            }
            case "3g": {
                mNetWorkType = 3;
                break;
            }
            case "2g": {
                mNetWorkType = 2;
                break;
            }
            case "4g": {
                mNetWorkType = 4;
                break;
            }
            case "5g": {
                mNetWorkType = 5;
                break;
            }
            default: {
                mNetWorkType = 0;
            }
        }
        return mNetWorkType;
    }

    private static boolean isFastMobileNetwork(Context context) {
        telephonyManager = (TelephonyManager)context.getSystemService("phone");
        switch (telephonyManager.getNetworkType()) {
            case 7: {
                return false;
            }
            case 4: {
                return false;
            }
            case 2: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 1: {
                return false;
            }
            case 8: {
                return true;
            }
            case 10: {
                return true;
            }
            case 9: {
                return true;
            }
            case 3: {
                return true;
            }
            case 14: {
                return true;
            }
            case 12: {
                return true;
            }
            case 15: {
                return true;
            }
            case 11: {
                return false;
            }
            case 13: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    public static String getIMEI(Context context) {
        String imei = null;
        telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            try {
                imei = telephonyManager.getDeviceId();
                if (TextUtils.isEmpty((CharSequence)imei) || "0".equals(imei) || "000000000000000".equals(imei)) {
                    imei = "";
                }
                YLog.d("Android Q \u9002\u914d\u65e0\u6cd5\u83b7\u53d6IMEI");
            }
            catch (SecurityException e) {
                imei = "";
            }
        }
        return imei;
    }

    public static String getIMSI(Context context) {
        String imsi = null;
        telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            try {
                imsi = telephonyManager.getDeviceId();
                if (TextUtils.isEmpty((CharSequence)imsi) || "0".equals(imsi) || "000000000000000".equals(imsi)) {
                    imsi = "";
                }
                YLog.d("Android Q \u9002\u914d\u65e0\u6cd5\u83b7\u53d6IMSI");
            }
            catch (SecurityException e) {
                imsi = "";
            }
        }
        return imsi;
    }

    public static String getHostIp() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> ipAddr = intf.getInetAddresses();
                while (ipAddr.hasMoreElements()) {
                    InetAddress inetAddress = ipAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        IMSI = "";
    }
}

