/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.sdk.kit;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.yodo1.sdk.kit.YFileUtils;
import com.yodo1.sdk.kit.YLog;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;

public class Yodo1DeviceUtils {
    private static final String TAG = "Yodo1DeviceUtils";

    public static String getPhoneBrand() {
        String handSetInfo = Build.BRAND;
        return handSetInfo;
    }

    public static String getPhoneVersion() {
        String handSetInfo = Build.MODEL;
        return handSetInfo;
    }

    public static String getOsVersion() {
        String handSetInfo = Build.VERSION.RELEASE;
        return handSetInfo;
    }

    public static String getMacAddress(Context context) {
        WifiInfo info;
        String macStr = "";
        WifiManager wifi = (WifiManager)context.getSystemService("wifi");
        if (wifi != null && (info = wifi.getConnectionInfo()) != null && TextUtils.isEmpty((CharSequence)(macStr = info.getMacAddress()))) {
            macStr = "";
        }
        return macStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGoogleAdId(Context context) throws Exception {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            return "Cannot call in the main thread, You must call in the other thread";
        }
        AdvertisingConnection connection = new AdvertisingConnection();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        if (context.bindService(intent, (ServiceConnection)connection, 1)) {
            try {
                AdvertisingInterface adInterface = new AdvertisingInterface(connection.getBinder());
                String string = adInterface.getId();
                return string;
            }
            finally {
                context.unbindService((ServiceConnection)connection);
            }
        }
        return "";
    }

    public static String getDeviceId(Context ctx) {
        String deviceId = YFileUtils.readFilesFromSDCard(".yodo1");
        if (TextUtils.isEmpty((CharSequence)deviceId) || deviceId.contains("openYodo1Log")) {
            deviceId = Yodo1DeviceUtils.getDeviceIdForSave(ctx);
        }
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = Yodo1DeviceUtils.getIMEI(ctx);
        }
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = UUID.randomUUID().toString();
            Yodo1DeviceUtils.saveDeviceId(ctx, deviceId);
            YFileUtils.writeFilesToSDCard(deviceId, ".yodo1");
        }
        return deviceId;
    }

    private static String getIMEI(Context context) {
        String imei = "";
        int permissionCheck = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE");
        if (permissionCheck == 0) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null && (TextUtils.isEmpty((CharSequence)(imei = telephonyManager.getDeviceId())) || "0".equals(imei) || "000000000000000".equals(imei))) {
                imei = "";
            }
        } else {
            YLog.d("\u6ca1READ_PHONE_STATE\u6743\u9650,\u65e0\u6cd5\u8bfb\u53d6IMEI");
        }
        return imei;
    }

    private static void saveDeviceId(Context context, String value) {
        SharedPreferences sp = context.getSharedPreferences("sp_yodo1games", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("user_device_id", value);
        editor.apply();
    }

    private static String getDeviceIdForSave(Context context) {
        SharedPreferences sp = context.getSharedPreferences("sp_yodo1games", 0);
        return sp.getString("user_device_id", null);
    }

    private static final class AdvertisingInterface
    implements IInterface {
        private IBinder binder;

        public AdvertisingInterface(IBinder pBinder) {
            this.binder = pBinder;
        }

        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getId() throws RemoteException {
            String id2;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, data, reply, 0);
                reply.readException();
                id2 = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return id2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLimitAdTrackingEnabled(boolean paramBoolean) throws RemoteException {
            boolean limitAdTracking;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(paramBoolean ? 1 : 0);
                this.binder.transact(2, data, reply, 0);
                reply.readException();
                limitAdTracking = 0 != reply.readInt();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return limitAdTracking;
        }
    }

    private static final class AdvertisingConnection
    implements ServiceConnection {
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);
        boolean retrieved = false;

        private AdvertisingConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.queue.put(service);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder getBinder() throws InterruptedException {
            if (this.retrieved) {
                throw new IllegalStateException();
            }
            this.retrieved = true;
            return this.queue.take();
        }
    }
}

