/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.sdk.kit;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.text.TextUtils;
import android.util.Base64;
import com.yodo1.sdk.kit.YLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Yodo1CommonUtils {
    public static String getMetedataStr(Context context, String key) {
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Object object = appInfo.metaData.get(key);
            return object.toString();
        }
        catch (Exception e) {
            YLog.d("Get meta-data failed, " + key + " was not found in the manifest");
            return "";
        }
    }

    public static boolean isMobile(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1,9][2,3,4,5,6,7,8,9][0-9]{9}$");
        m = p.matcher(str);
        b = m.matches();
        return b;
    }

    public static Long getLongValues(String str) {
        Long value = 0L;
        if (TextUtils.isEmpty((CharSequence)str)) {
            return value;
        }
        try {
            value = Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            value = 0L;
            YLog.d("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38 NumberFormatException  \u5f02\u5e38\u5185\u5bb9\uff1a " + str);
        }
        return value;
    }

    public static long getUTCTime() {
        Calendar cal = Calendar.getInstance();
        return cal.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzipCompress(String data) throws IOException {
        if (data == null || data.length() == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream baostream = null;
        GZIPOutputStream outStream = null;
        try {
            baostream = new ByteArrayOutputStream();
            outStream = new GZIPOutputStream(baostream){};
            outStream.write(data.getBytes("UTF-8"));
            outStream.close();
            byte[] byArray = baostream.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (baostream != null) {
                    baostream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String hmacWithKey(String key, byte[] data) {
        String result = "";
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            result = Base64.encodeToString((byte[])sha256_HMAC.doFinal(data), (int)0);
            YLog.d("hmacWithKey result==" + result);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }
}

