/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.sdk.kit;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.yodo1.sdk.kit.YFileUtils;
import com.yodo1.sdk.kit.YLog;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YDeviceIDUtils {
    public static boolean isMobile(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$");
        m = p.matcher(str);
        b = m.matches();
        return b;
    }

    public static String getDeviceId(Context ctx) {
        String deviceId = YFileUtils.readFilesFromSDCard(".yodo1");
        if (TextUtils.isEmpty((CharSequence)deviceId) || deviceId.contains("openYodo1Log")) {
            deviceId = YDeviceIDUtils.getDeviceIdForSave(ctx);
        }
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = YDeviceIDUtils.getIMEI(ctx);
        }
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = UUID.randomUUID().toString();
            YDeviceIDUtils.saveDeviceId(ctx, deviceId);
            YFileUtils.writeFilesToSDCard(deviceId, ".yodo1");
        }
        return deviceId;
    }

    private static String getIMEI(Context context) {
        String imei = "";
        int permissionCheck = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE");
        if (permissionCheck == 0) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null && (TextUtils.isEmpty((CharSequence)(imei = telephonyManager.getDeviceId())) || "0".equals(imei) || "000000000000000".equals(imei))) {
                imei = "";
            }
        } else {
            YLog.d("\u6ca1READ_PHONE_STATE\u6743\u9650,\u65e0\u6cd5\u8bfb\u53d6IMEI");
        }
        return imei;
    }

    private static String getMAC(Context context) {
        WifiInfo info;
        String macStr = "";
        WifiManager wifi = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (wifi != null && (info = wifi.getConnectionInfo()) != null && TextUtils.isEmpty((CharSequence)(macStr = info.getMacAddress()))) {
            macStr = "";
        }
        return macStr;
    }

    private static final String getSerial() {
        String serialnum = null;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class, String.class);
            serialnum = (String)get.invoke(c, "ro.serialno", "unknown");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serialnum;
    }

    private static String getAndroidID(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return androidId;
    }

    private static void saveDeviceId(Context context, String value) {
        SharedPreferences sp = context.getSharedPreferences("sp_yodo1games", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("user_device_id", value);
        editor.apply();
    }

    private static String getDeviceIdForSave(Context context) {
        SharedPreferences sp = context.getSharedPreferences("sp_yodo1games", 0);
        return sp.getString("user_device_id", null);
    }

    private static void saveDeviceIdNew(Context context, String value) {
        SharedPreferences sp = context.getSharedPreferences("sp_yodo1games", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("user_device_id_new", value);
        editor.apply();
    }

    private static String getDeviceIdForSaveNew(Context context) {
        SharedPreferences sp = context.getSharedPreferences("sp_yodo1games", 0);
        return sp.getString("user_device_id_new", null);
    }
}

