/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.sdk.kit;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import java.util.ArrayList;
import java.util.List;

public class ValidateUtils {
    public static boolean validateActivities(Activity activity, List<String> activities) {
        boolean result = true;
        PackageManager packageManager = activity.getPackageManager();
        for (String act : activities) {
            try {
                Class<?> localClass = Class.forName(act);
                Intent intent = new Intent((Context)activity, localClass);
                List list = packageManager.queryIntentActivities(intent, 65536);
                if (list.size() > 0) {
                    ValidateUtils.validationMessageIsPresent(act, true);
                    continue;
                }
                result = false;
                ValidateUtils.validationMessageIsPresent(act, false);
            }
            catch (ClassNotFoundException e) {
                result = false;
                ValidateUtils.validationMessageIsPresent(act, false);
            }
        }
        return result;
    }

    public static boolean validatePermissions(Activity activity, List<String> permissions) {
        boolean result = true;
        PackageManager packageManager = activity.getPackageManager();
        for (String permission2 : permissions) {
            int permissionExists = packageManager.checkPermission(permission2, activity.getPackageName());
            if (permissionExists == 0) {
                ValidateUtils.validationMessageIsPresent(permission2, true);
                continue;
            }
            result = false;
            ValidateUtils.validationMessageIsPresent(permission2, false);
        }
        return result;
    }

    public static boolean validateExternalLibraries(ArrayList<Pair<String, String>> externalLibraries) {
        boolean result = true;
        for (Pair<String, String> externalLibrary : externalLibraries) {
            try {
                Class<?> localClass = Class.forName((String)externalLibrary.first);
                ValidateUtils.validationMessageIsPresent((String)externalLibrary.second, true);
            }
            catch (ClassNotFoundException e) {
                result = false;
                ValidateUtils.validationMessageIsPresent((String)externalLibrary.second, false);
            }
        }
        return result;
    }

    public static boolean validateBroadcastReceivers(Activity activity, List<String> broadcastReceivers) {
        boolean result = true;
        PackageManager packageManager = activity.getPackageManager();
        for (String broadcastReceiver : broadcastReceivers) {
            try {
                Class<?> localClass = Class.forName(broadcastReceiver);
                Intent intent = new Intent((Context)activity, localClass);
                List list = packageManager.queryBroadcastReceivers(intent, 65536);
                if (list.size() > 0) {
                    ValidateUtils.validationMessageIsPresent(broadcastReceiver, true);
                    continue;
                }
                result = false;
                ValidateUtils.validationMessageIsPresent(broadcastReceiver, false);
            }
            catch (ClassNotFoundException e) {
                result = false;
                ValidateUtils.validationMessageIsPresent(broadcastReceiver, false);
            }
        }
        return result;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean validateContentProviders(Activity activity, List<String> providers) {
        boolean result = true;
        PackageManager packageManager = activity.getPackageManager();
        for (String provider : providers) {
            try {
                Class<?> localClass = Class.forName(provider);
                Intent intent = new Intent((Context)activity, localClass);
                List list = packageManager.queryIntentContentProviders(intent, 65536);
                if (list.size() > 0) {
                    ValidateUtils.validationMessageIsPresent(provider, true);
                    continue;
                }
                result = false;
                ValidateUtils.validationMessageIsPresent(provider, false);
            }
            catch (ClassNotFoundException e) {
                result = false;
                ValidateUtils.validationMessageIsPresent(provider, false);
            }
        }
        return result;
    }

    public static boolean validateServices(Activity activity, List<String> services) {
        boolean result = true;
        PackageManager packageManager = activity.getPackageManager();
        for (String service : services) {
            try {
                Class<?> localClass = Class.forName(service);
                Intent intent = new Intent((Context)activity, localClass);
                List list = packageManager.queryIntentServices(intent, 65536);
                if (list.size() > 0) {
                    ValidateUtils.validationMessageIsPresent(service, true);
                    continue;
                }
                result = false;
                ValidateUtils.validationMessageIsPresent(service, false);
            }
            catch (ClassNotFoundException e) {
                result = false;
                ValidateUtils.validationMessageIsPresent(service, false);
            }
        }
        return result;
    }

    public static boolean validateMetaData(Activity activity, List<String> metaData) {
        boolean result = true;
        ApplicationInfo appInfo = null;
        try {
            appInfo = activity.getPackageManager().getApplicationInfo(activity.getPackageName(), 128);
            for (String meta : metaData) {
                String data = appInfo.metaData.get(meta).toString();
                if (!TextUtils.isEmpty((CharSequence)data)) {
                    result = true;
                    ValidateUtils.validationMessageIsPresent(meta, true);
                    continue;
                }
                result = false;
                ValidateUtils.validationMessageIsPresent(meta, false);
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static final void getActivitiesClass(Context context, String activityName) {
        ArrayList returnClassList = new ArrayList();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 1);
            if (packageInfo.activities != null) {
                for (ActivityInfo ai : packageInfo.activities) {
                    if (!ai.name.equals(activityName)) continue;
                    ValidateUtils.validationMessageIsPresent(activityName, true);
                    return;
                }
            }
            ValidateUtils.validationMessageIsPresent(activityName, false);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static final void getServiceClass(Context context, String serviceName) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4);
            if (packageInfo.services != null) {
                for (ServiceInfo ai : packageInfo.services) {
                    if (!ai.name.equals(serviceName)) continue;
                    ValidateUtils.validationMessageIsPresent(serviceName, true);
                    return;
                }
            }
            ValidateUtils.validationMessageIsPresent(serviceName, false);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static final void getReceiverClass(Context context, String receiverName) {
        ArrayList returnClassList = new ArrayList();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 2);
            if (packageInfo.receivers != null) {
                for (ActivityInfo ai : packageInfo.receivers) {
                    if (!ai.name.equals(receiverName)) continue;
                    ValidateUtils.validationMessageIsPresent(receiverName, true);
                    return;
                }
            }
            ValidateUtils.validationMessageIsPresent(receiverName, false);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void validationMessageIsPresent(String paramToValidate, boolean successful) {
        if (successful) {
            Log.i((String)"Yodo1IntegrationHelper", (String)(paramToValidate + " - VERIFIED"));
        } else {
            Log.e((String)"Yodo1IntegrationHelper", (String)(paramToValidate + " - MISSING"));
        }
    }
}

