/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.sdk.kit;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Environment;
import java.io.InputStream;
import java.util.List;

public class SysUtils {
    public static String getSignature(Context ctx) {
        try {
            PackageManager manager = ctx.getPackageManager();
            PackageInfo packageInfo = manager.getPackageInfo(ctx.getPackageName(), 64);
            Signature[] signatures = packageInfo.signatures;
            StringBuilder sb = new StringBuilder();
            for (Signature signature : signatures) {
                sb.append(signature.toCharsString());
            }
            return sb.toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final String getSDCardPath() {
        String sdcardDir = null;
        boolean sdcardExist = Environment.getExternalStorageState().equals("mounted");
        if (sdcardExist) {
            sdcardDir = Environment.getExternalStorageDirectory().toString();
        }
        return sdcardDir.toString();
    }

    public static String loadAssetsForTxt(Context context, String filename) {
        String content = "";
        try {
            InputStream is = context.getAssets().open(filename);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            content = new String(buffer, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    public static String getProcessName(Context cxt, int pid) {
        ActivityManager am = (ActivityManager)cxt.getSystemService("activity");
        List runningApps = am.getRunningAppProcesses();
        if (runningApps == null) {
            return null;
        }
        for (ActivityManager.RunningAppProcessInfo procInfo : runningApps) {
            if (procInfo.pid != pid) continue;
            return procInfo.processName;
        }
        return null;
    }

    public static int getVersionCode(Context context) {
        try {
            PackageInfo pinfo = context.getApplicationContext().getPackageManager().getPackageInfo(context.getApplicationContext().getPackageName(), 0);
            return pinfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String getVersionName(Context context) {
        try {
            PackageInfo pinfo = context.getApplicationContext().getPackageManager().getPackageInfo(context.getApplicationContext().getPackageName(), 0);
            return pinfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "unknown";
        }
    }

    public static String getAppName(Context context) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
        }
        String applicationName = (String)packageManager.getApplicationLabel(applicationInfo);
        return applicationName;
    }

    public static boolean isAppOnForeground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getApplicationContext().getSystemService("activity");
        String packageName = context.getApplicationContext().getPackageName();
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(packageName) || appProcess.importance != 100) continue;
            return true;
        }
        return false;
    }

    public static String getPackageName(Context context) {
        try {
            PackageInfo pinfo = context.getApplicationContext().getPackageManager().getPackageInfo(context.getApplicationContext().getPackageName(), 0);
            return pinfo.packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "unknown";
        }
    }
}

