/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.plugin.dmp.yodo1.helper;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.yodo1.android.ops.net.HttpListener;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.android.ops.net.Yodo1RequestListener;
import com.yodo1.android.ops.net.Yodo1SDKResponse;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.plugin.dmp.yodo1.constants.AnalyticsInfo;
import com.yodo1.plugin.dmp.yodo1.db.Yodo1UtilDao;
import com.yodo1.plugin.dmp.yodo1.helper.Yodo1AnalyticsManage;
import com.yodo1.sdk.kit.MD5EncodeUtil;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sdk.kit.Yodo1DeviceUtils;
import com.yodo1.sdk.kit.Yodo1OperatorUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Yodo1AnalyticsForYodo1
implements Yodo1RequestListener {
    private static final String TAG = "[Yodo1AnalyticsForYodo1] ";
    private static final String URL_LOG_EVENT = "https://da.yodo1api.com/log/event";
    private static long launchtime;
    private static long uptime;
    private static String sdk_version;
    private static Yodo1AnalyticsForYodo1 instance;
    private Yodo1UtilDao dao;
    private String device_id = "";
    private String appKey = "";
    private Activity mainActivity;

    public void initSDK(Activity activity, String appKey) {
        this.mainActivity = activity;
        this.appKey = appKey;
        this.device_id = Yodo1DeviceUtils.getDeviceId((Context)activity);
        sdk_version = Yodo1OnlineConfig.SDKVersion;
        if (TextUtils.isEmpty((CharSequence)sdk_version)) {
            sdk_version = "1.0.0";
        }
        if (this.dao == null) {
            this.dao = new Yodo1UtilDao((Context)activity);
        }
        if (this.dao.getLines() > 10000L) {
            this.dao.deleteALL();
        }
    }

    public void onResume(Activity activity) {
        launchtime = Yodo1CommonUtils.getUTCTime();
    }

    public void onEvent(String eventId, HashMap<String, Object> map) {
        String channel_code = "";
        if (this.mainActivity != null) {
            channel_code = Yodo1SharedPreferences.getString((Context)this.mainActivity, "ChannelCode");
        }
        if (TextUtils.isEmpty((CharSequence)channel_code)) {
            channel_code = Yodo1OnlineConfig.ChannelCode;
        }
        JSONObject eventdataJson = new JSONObject();
        try {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                eventdataJson.put(entry.getKey(), entry.getValue());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        AnalyticsInfo info = new AnalyticsInfo();
        info.setChannel(channel_code);
        info.setSessionid(Yodo1AnalyticsManage.sessionid);
        info.setTimestamp(Yodo1CommonUtils.getUTCTime() + "");
        info.setDevice_id(this.device_id);
        info.setEventid(eventId);
        info.setEvent_data(eventdataJson.toString());
        info.setClient_version(SysUtils.getVersionName((Context)this.mainActivity));
        info.setEvent_type("event");
        YLog.d("[Yodo1AnalyticsForYodo1] event \u4e8b\u4ef6\u4fe1\u606f\u4e3a \uff1a " + info.toString());
        this.dao.add(info);
    }

    public void saveLaunchEvent(Context context, String sessionid, String lastTimeSessionid, String duration) {
        String channel_code = "";
        if (this.mainActivity != null) {
            channel_code = Yodo1SharedPreferences.getString((Context)this.mainActivity, "ChannelCode");
        }
        if (TextUtils.isEmpty((CharSequence)channel_code)) {
            channel_code = Yodo1OnlineConfig.ChannelCode;
        }
        try {
            JSONObject terminalJson = new JSONObject();
            terminalJson.put("sessionid", (Object)lastTimeSessionid);
            terminalJson.put("duration", (Object)(TextUtils.isEmpty((CharSequence)duration) ? "0" : duration));
            AnalyticsInfo info = new AnalyticsInfo();
            info.setChannel(channel_code);
            info.setSessionid(sessionid);
            info.setTimestamp(launchtime + "");
            info.setOs("android");
            info.setNetwork(Yodo1OperatorUtils.getNetWorkType(context));
            info.setDevice_id(this.device_id);
            info.setOs_version(Yodo1DeviceUtils.getOsVersion());
            info.setPhone_version(Yodo1DeviceUtils.getPhoneVersion());
            info.setDevice_name(Yodo1DeviceUtils.getPhoneBrand());
            info.setBundle_id(SysUtils.getPackageName(context));
            info.setClient_version(SysUtils.getVersionName(context));
            info.setTerminal(terminalJson.toString());
            info.setEvent_type("launch");
            YLog.d("[Yodo1AnalyticsForYodo1] launch \u4e8b\u4ef6\u4fe1\u606f\u4e3a \uff1a " + info.toString());
            this.dao.add(info);
            this.Update(this);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void Update(final Yodo1RequestListener listener) {
        if (TextUtils.isEmpty((CharSequence)this.appKey)) {
            YLog.d("[Yodo1AnalyticsForYodo1] appKey\u4e3a\u7a7a, \u4e2d\u6b62\u4e0a\u62a5");
            return;
        }
        YLog.d("[Yodo1AnalyticsForYodo1] \u5f53\u524d\u65f6\u95f4: " + Yodo1CommonUtils.getUTCTime());
        YLog.d("[Yodo1AnalyticsForYodo1] \u4e0a\u4e00\u6b21\u4e0a\u4f20\u65f6\u95f4: " + uptime);
        if (Yodo1CommonUtils.getUTCTime() - uptime < 297000L) {
            YLog.d("[Yodo1AnalyticsForYodo1] 5min\u4e0a\u62a5\u4e00\u6b21\u6570\u636e, \u672a\u6ee1\u8db3\u4e0a\u62a5\u65f6\u95f4, \u4e2d\u6b62\u4e0a\u62a5");
            return;
        }
        uptime = Yodo1CommonUtils.getUTCTime();
        String timestamp = Yodo1CommonUtils.getUTCTime() + "";
        String sign = MD5EncodeUtil.MD5Encode(this.appKey + timestamp + "logupload");
        List<AnalyticsInfo> infos = this.dao.queryAllAnalyticsInfo();
        if (infos == null || infos.size() == 0) {
            YLog.d("[Yodo1AnalyticsForYodo1] \u4e0a\u62a5\u6570\u636e\u4e3a\u7a7a, \u4e2d\u6b62\u4e0a\u62a5");
            return;
        }
        JSONObject updataJson = new JSONObject();
        try {
            JSONArray array = new JSONArray();
            for (int j = 0; j < infos.size(); ++j) {
                JSONObject object = new JSONObject();
                JSONObject objectDetial = new JSONObject();
                AnalyticsInfo info = infos.get(j);
                if (info.getEvent_type().equals("event")) {
                    objectDetial.put("sessionid", (Object)info.getSessionid());
                    objectDetial.put("timestamp", (Object)info.getTimestamp());
                    objectDetial.put("device_id", (Object)info.getDevice_id());
                    objectDetial.put("eventid", (Object)info.getEventid());
                    objectDetial.put("event_data", (Object)new JSONObject(info.getEvent_data()));
                    objectDetial.put("channel", (Object)info.getChannel());
                    objectDetial.put("client_version", (Object)info.getClient_version());
                    object.put("event", (Object)objectDetial);
                } else {
                    objectDetial.put("sessionid", (Object)info.getSessionid());
                    objectDetial.put("timestamp", (Object)info.getTimestamp());
                    objectDetial.put("device_id", (Object)info.getDevice_id());
                    objectDetial.put("channel", (Object)info.getChannel());
                    objectDetial.put("client_version", (Object)info.getClient_version());
                    objectDetial.put("os", (Object)info.getOs());
                    objectDetial.put("os_version", (Object)info.getOs_version());
                    objectDetial.put("phone_version", (Object)info.getPhone_version());
                    objectDetial.put("device_name", (Object)info.getDevice_name());
                    objectDetial.put("bundle_id", (Object)info.getBundle_id());
                    objectDetial.put("terminal", (Object)new JSONObject(info.getTerminal()));
                    object.put("launch", (Object)objectDetial);
                }
                array.put((Object)object);
            }
            updataJson.put("game_appkey", (Object)this.appKey);
            updataJson.put("timestamp", (Object)timestamp);
            updataJson.put("data", (Object)array);
            updataJson.put("sdk_version", (Object)sdk_version);
            updataJson.put("sign", (Object)sign);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String submitStr = updataJson.toString();
        YLog.d("[Yodo1AnalyticsForYodo1] Request body: " + submitStr);
        Request<String> request = NoHttp.createStringRequest(URL_LOG_EVENT, RequestMethod.POST);
        byte[] payloadData = null;
        try {
            payloadData = Yodo1CommonUtils.gzipCompress(submitStr);
            request.addHeader("Content-Length", String.valueOf(payloadData.length));
            request.addHeader("Content-Encoding", "gzip");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteArrayInputStream input = new ByteArrayInputStream(payloadData);
        request.setDefineRequestBody(input, "application/json");
        YLog.d("[Yodo1AnalyticsForYodo1] Sending POST request to " + request.url());
        Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>(){

            @Override
            public void onSucceed(int what, Response<String> response) {
                YLog.d("[Yodo1AnalyticsForYodo1] Connect onSucceed, the response: " + response.get());
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                listener.onYodo1RequestComplete(resp);
            }

            @Override
            public void onFailed(int what, Response<String> response) {
                YLog.d("[Yodo1AnalyticsForYodo1] Connect onFailed");
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                listener.onYodo1RequestComplete(resp);
            }
        }, false);
    }

    @Override
    public void onYodo1RequestComplete(Yodo1SDKResponse responseObject) {
        String resMsg = responseObject.getResponseString();
        YLog.d("[Yodo1AnalyticsForYodo1] yodo1\u6e38\u620f\u4e8b\u4ef6 \u4e0a\u62a5\u7ed3\u679c\uff1a " + resMsg);
        if (!TextUtils.isEmpty((CharSequence)resMsg)) {
            try {
                JSONObject jsonObj = new JSONObject(resMsg);
                int errorCode = jsonObj.optInt("error_code");
                if (errorCode == 0) {
                    YLog.d("[Yodo1AnalyticsForYodo1] yodo1\u6e38\u620f\u4e8b\u4ef6 \u4e0a\u62a5\u6210\u529f ");
                    this.dao.deleteALL();
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            YLog.d("[Yodo1AnalyticsForYodo1] yodo1\u6e38\u620f\u4e8b\u4ef6 \u4e0a\u62a5\u5931\u8d25  \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a ");
        }
    }

    static {
        sdk_version = "1.1.1";
    }
}

