/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.plugin.dmp.yodo1.db;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.yodo1.plugin.dmp.yodo1.constants.AnalyticsInfo;
import com.yodo1.plugin.dmp.yodo1.db.Yodo1DBUtil;
import java.util.ArrayList;
import java.util.List;

public class Yodo1UtilDao {
    private Yodo1DBUtil du;
    private SQLiteDatabase db;
    private String tableName = "Yodo1AnalyticsDB";

    public Yodo1UtilDao(Context context) {
        this.du = new Yodo1DBUtil(context, this.tableName);
        this.db = this.du.getWritableDatabase();
    }

    public long getLines() {
        Cursor cursor = this.db.rawQuery("select count(*) from " + this.tableName, null);
        cursor.moveToFirst();
        long count = cursor.getLong(0);
        cursor.close();
        return count;
    }

    public void add(AnalyticsInfo info) {
        this.db.execSQL("insert into " + this.tableName + " values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{info.getSessionid(), info.getTimestamp(), info.getEventid(), info.getEvent_data(), info.getChannel(), info.getClient_version(), info.getEvent_type(), info.getNetwork(), info.getDevice_id(), info.getTerminal(), info.getBundle_id(), info.getDevice_name(), info.getPhone_version(), info.getOs_version(), info.getOs()});
    }

    public void update(AnalyticsInfo info) {
        this.db.execSQL("update " + this.tableName + " set sessionid=?,timestamp=?,eventid=?,event_data=?,channel=?,client_version=?,event_type=?,network=?,device_id=?,terminal=?,bundle_id=?,device_name=?,phone_version=?,os_version=?,os=? where _id=?", new Object[]{info.getSessionid(), info.getTimestamp(), info.getEventid(), info.getEvent_data(), info.getChannel(), info.getClient_version(), info.getEvent_type(), info.getNetwork(), info.getDevice_id(), info.getTerminal(), info.getBundle_id(), info.getDevice_name(), info.getPhone_version(), info.getOs_version(), info.getOs()});
    }

    public void delete(String name) {
        this.db.execSQL("delete from " + this.tableName + "  where name=?", (Object[])new String[]{name});
    }

    public void deleteALL() {
        this.db.execSQL("delete from " + this.tableName);
    }

    public AnalyticsInfo queryOne(String name) {
        AnalyticsInfo info = new AnalyticsInfo();
        Cursor c = this.db.rawQuery("select * from " + this.tableName + " where name= ?", new String[]{name});
        while (c.moveToNext()) {
            info.setSessionid(c.getString(0));
            info.setTimestamp(c.getString(1));
            info.setEventid(c.getString(2));
            info.setEvent_data(c.getString(3));
            info.setChannel(c.getString(4));
            info.setClient_version(c.getString(5));
            info.setEvent_type(c.getString(6));
            info.setNetwork(c.getString(7));
            info.setDevice_id(c.getString(8));
            info.setTerminal(c.getString(9));
            info.setBundle_id(c.getString(10));
            info.setDevice_name(c.getString(11));
            info.setPhone_version(c.getString(12));
            info.setOs_version(c.getString(13));
            info.setOs(c.getString(14));
        }
        c.close();
        return info;
    }

    public List<AnalyticsInfo> queryAllAnalyticsInfo() {
        ArrayList<AnalyticsInfo> infos = new ArrayList<AnalyticsInfo>();
        Cursor c = this.db.rawQuery("select * from " + this.tableName, null);
        while (c.moveToNext()) {
            AnalyticsInfo info = new AnalyticsInfo();
            info.setSessionid(c.getString(0));
            info.setTimestamp(c.getString(1));
            info.setEventid(c.getString(2));
            info.setEvent_data(c.getString(3));
            info.setChannel(c.getString(4));
            info.setClient_version(c.getString(5));
            info.setEvent_type(c.getString(6));
            info.setNetwork(c.getString(7));
            info.setDevice_id(c.getString(8));
            info.setTerminal(c.getString(9));
            info.setBundle_id(c.getString(10));
            info.setDevice_name(c.getString(11));
            info.setPhone_version(c.getString(12));
            info.setOs_version(c.getString(13));
            info.setOs(c.getString(14));
            infos.add(info);
        }
        c.close();
        return infos;
    }

    public void getClose() {
        if (this.db != null) {
            this.db.close();
        }
    }
}

