/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.onlineconfig;

import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationManager;
import android.os.Looper;
import android.text.TextUtils;
import com.yodo1.android.ops.net.HttpListener;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.android.ops.net.Yodo1RequestListener;
import com.yodo1.android.ops.net.Yodo1SDKResponse;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.onlineconfig.JsonCacheUtils;
import com.yodo1.onlineconfig.Yodo1OnlineConfigListener;
import com.yodo1.sdk.kit.MD5EncodeUtil;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sdk.kit.Yodo1DeviceUtils;
import com.yodo1.sdk.kit.Yodo1PermissonUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;
import org.json.JSONException;
import org.json.JSONObject;

public class Yodo1OnlineConfig {
    private static final String TAG = "[Yodo1OnlineConfig] ";
    public static final String ONLINECONFIG_ACTION = "cn.yodo1.broadcastreceiverregister.OnlineConfig";
    public static final String ENV_BUILD_PRODUCTION = "product";
    public static final String ENV_BUILD_TEST = "test";
    private static final String KEY_CACHE_FILE_JSON = "onlineconfig";
    private static final String URL_ONLINECONFIG_PRODUCT = "https://olc.yodo1api.com/config/getDataV2/";
    private static final String URL_ONLINECONFIG_TEST = "http://olc-test.yodo1.int:8080/config/getDataV2";
    private static final String URL_ONLINECONFIG_CDN = "https://ocd.yodo1api.com/configfiles/";
    private static final String KEY_DATA_IDENTIFER = "data_identifer";
    private static final String KEY_LOCATION_IDENTIFER = "location_identifer";
    private static final String KEY_LOCATION_IDENTIFER_TTL = "location_identifer_ttl";
    private static final String KEY_GAME_APPK = "game_appkey";
    private static final String KEY_GAME_CHANNEL_CODE = "game_channelcode";
    private static final String KEY_GAME_VERSION_NAME = "game_version";
    private static final String KEY_GAME_PACKAGE_NAME = "game_packagename";
    private static final String KEY_TIMESTAMP_GETDATA = "timestamp_getdata";
    private static final String KEY_ONLINECONFIG_TEST_INFO = "OnlineConfigParams_TestInfo";
    private static final String KEY_ONLINECONFIG_TESTDEVICE = "OnlineConfigParams_TestDevice";
    private static final String KEY_ONLINECONFIG_TESTDEVICE_SOURCE = "OnlineConfigParams_TestDeviceSource";
    private static String buildCode = "product";
    public static String ChannelCode = "";
    public static String SDKVersion = "";
    public static String SDKTyoe = "";
    private static String appKey;
    private static String appPackageName;
    private static String appVersionName;
    private static long time;
    private static Context context;
    private static String location_lng;
    private static String location_lat;
    private static volatile Yodo1OnlineConfig instance;
    public JSONObject dataObj = null;
    public JSONObject testObj = null;
    private boolean initialized = false;

    private Yodo1OnlineConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Yodo1OnlineConfig getInstance() {
        if (instance != null) return instance;
        Class<Yodo1OnlineConfig> clazz = Yodo1OnlineConfig.class;
        synchronized (Yodo1OnlineConfig.class) {
            if (instance != null) return instance;
            instance = new Yodo1OnlineConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setBuildCode(String buildCode) {
        Yodo1OnlineConfig.buildCode = buildCode;
    }

    private String getOnlineConfigUrl() {
        if (!TextUtils.isEmpty((CharSequence)buildCode) && buildCode.equals(ENV_BUILD_TEST)) {
            return URL_ONLINECONFIG_TEST;
        }
        return URL_ONLINECONFIG_PRODUCT;
    }

    private void getOnlineConfig(final Yodo1RequestListener listener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                try {
                    String deviceId = Yodo1DeviceUtils.getGoogleAdId(context);
                    if (TextUtils.isEmpty((CharSequence)deviceId)) {
                        deviceId = Yodo1DeviceUtils.getDeviceId(context);
                    }
                    Yodo1SharedPreferences.put(context, "YDEVICEID", deviceId);
                    String data = Yodo1SharedPreferences.getString(context, Yodo1OnlineConfig.KEY_DATA_IDENTIFER);
                    String data_identifer = !TextUtils.isEmpty((CharSequence)data) ? (!data.equals("null") ? data : "0") : "0";
                    String time = System.currentTimeMillis() + "";
                    String sign = MD5EncodeUtil.MD5Encode(appKey + appVersionName + ChannelCode + time + "yodo1");
                    String location_identifer = Yodo1SharedPreferences.getString(context, Yodo1OnlineConfig.KEY_LOCATION_IDENTIFER);
                    if (!TextUtils.isEmpty((CharSequence)location_identifer)) {
                        String location_identifer_ttl = Yodo1SharedPreferences.getString(context, Yodo1OnlineConfig.KEY_LOCATION_IDENTIFER_TTL);
                        String timestamp_getdata = Yodo1SharedPreferences.getString(context, Yodo1OnlineConfig.KEY_TIMESTAMP_GETDATA);
                        try {
                            long time_ttl = Long.valueOf(location_identifer_ttl);
                            long time_getdata = Long.valueOf(timestamp_getdata);
                            long time_now = Long.valueOf(time);
                            if (time_getdata - time_now > time_ttl * 60L * 60L * 1000L) {
                                location_identifer = "";
                                data_identifer = "0";
                                Yodo1SharedPreferences.put(context, Yodo1OnlineConfig.KEY_LOCATION_IDENTIFER, "");
                            }
                        }
                        catch (NumberFormatException e) {
                            location_identifer = "";
                        }
                    } else {
                        location_identifer = "";
                    }
                    JSONObject dataJson = new JSONObject();
                    try {
                        dataJson.put(Yodo1OnlineConfig.KEY_GAME_APPK, (Object)appKey);
                        dataJson.put("device_id", (Object)deviceId);
                        dataJson.put("version", (Object)appVersionName);
                        dataJson.put("channel", (Object)ChannelCode);
                        dataJson.put("sdk_type", (Object)SDKTyoe);
                        dataJson.put("sdk_version", (Object)SDKVersion);
                        dataJson.put(Yodo1OnlineConfig.KEY_DATA_IDENTIFER, (Object)data_identifer);
                        dataJson.put(Yodo1OnlineConfig.KEY_LOCATION_IDENTIFER, (Object)location_identifer);
                        dataJson.put("location_lng", (Object)location_lng);
                        dataJson.put("location_lat", (Object)location_lat);
                        dataJson.put("timestamp", (Object)time);
                        dataJson.put("sign", (Object)sign);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    String submitStr = dataJson.toString();
                    YLog.d("[Yodo1OnlineConfig] Request body: " + submitStr);
                    String url = Yodo1OnlineConfig.this.getOnlineConfigUrl();
                    Request<String> request = NoHttp.createStringRequest(url, RequestMethod.POST);
                    request.setDefineRequestBody(submitStr, "text/plain;charset=UTF-8");
                    YLog.d("[Yodo1OnlineConfig] Sending POST request to " + request.url());
                    Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>(){

                        @Override
                        public void onSucceed(int what, Response<String> response) {
                            YLog.d("[Yodo1OnlineConfig] Connect onSucceed, the response: " + response.get());
                            Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                            listener.onYodo1RequestComplete(resp);
                        }

                        @Override
                        public void onFailed(int what, Response<String> response) {
                            YLog.d("[Yodo1OnlineConfig] Connect onFailed");
                            Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                            listener.onYodo1RequestComplete(resp);
                        }
                    }, false);
                }
                catch (Exception exception) {
                }
                catch (Error error) {
                    // empty catch block
                }
                Looper.loop();
            }
        }).start();
    }

    public JSONObject getJsonData() throws JSONException {
        if (this.dataObj != null) {
            return this.dataObj;
        }
        String data = JsonCacheUtils.readJson(context, KEY_CACHE_FILE_JSON);
        if (!TextUtils.isEmpty((CharSequence)data)) {
            this.dataObj = new JSONObject(data);
        }
        return this.dataObj;
    }

    public JSONObject getJsonTestData() throws JSONException {
        if (this.testObj != null) {
            return this.testObj;
        }
        String data = Yodo1SharedPreferences.getString(context, KEY_ONLINECONFIG_TEST_INFO);
        if (!TextUtils.isEmpty((CharSequence)data)) {
            this.testObj = new JSONObject(data);
        }
        return this.testObj;
    }

    public boolean hasData() {
        boolean bl = false;
        String data = JsonCacheUtils.readJson(context, KEY_CACHE_FILE_JSON);
        if (!TextUtils.isEmpty((CharSequence)data)) {
            bl = true;
        }
        return bl;
    }

    public void getOnlineConfig(final Yodo1OnlineConfigListener listener) {
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            return;
        }
        if (System.currentTimeMillis() - time < 1200000L) {
            return;
        }
        time = System.currentTimeMillis();
        this.getOnlineConfig(new Yodo1RequestListener(){

            @Override
            public void onYodo1RequestComplete(Yodo1SDKResponse responseObject) {
                String resMsg = responseObject.getResponseString();
                YLog.d("[Yodo1OnlineConfig] onYodo1RequestComplete, the response string: " + resMsg);
                int errorCode = -1;
                try {
                    if (resMsg != null) {
                        JSONObject jsonObj = new JSONObject(resMsg);
                        errorCode = jsonObj.optInt("error_code");
                        if (errorCode == 0) {
                            String data_identifer = jsonObj.optString(Yodo1OnlineConfig.KEY_DATA_IDENTIFER);
                            String location_identifer = jsonObj.optString(Yodo1OnlineConfig.KEY_LOCATION_IDENTIFER);
                            String location_identifer_ttl = jsonObj.optString(Yodo1OnlineConfig.KEY_LOCATION_IDENTIFER_TTL);
                            Yodo1SharedPreferences.put(context, Yodo1OnlineConfig.KEY_DATA_IDENTIFER, data_identifer);
                            if (TextUtils.isEmpty((CharSequence)Yodo1SharedPreferences.getString(context, Yodo1OnlineConfig.KEY_LOCATION_IDENTIFER))) {
                                Yodo1SharedPreferences.put(context, Yodo1OnlineConfig.KEY_LOCATION_IDENTIFER, location_identifer);
                            }
                            Yodo1SharedPreferences.put(context, Yodo1OnlineConfig.KEY_LOCATION_IDENTIFER_TTL, location_identifer_ttl);
                            boolean is_test_model = jsonObj.optBoolean("is_test_model");
                            String device_source = jsonObj.optString("device_source");
                            JSONObject testListObj = jsonObj.optJSONObject("test_list");
                            Yodo1SharedPreferences.put(context, Yodo1OnlineConfig.KEY_ONLINECONFIG_TESTDEVICE, is_test_model);
                            Yodo1SharedPreferences.put(context, Yodo1OnlineConfig.KEY_ONLINECONFIG_TESTDEVICE_SOURCE, device_source);
                            if (testListObj != null) {
                                Yodo1SharedPreferences.put(context, Yodo1OnlineConfig.KEY_ONLINECONFIG_TEST_INFO, testListObj.toString());
                            }
                            JSONObject objData = jsonObj.optJSONObject("data");
                            objData.put("is_test_model", is_test_model);
                            objData.put("device_source", (Object)device_source);
                            JsonCacheUtils.writeJson(context, objData, Yodo1OnlineConfig.KEY_CACHE_FILE_JSON);
                            Yodo1SharedPreferences.put(context, Yodo1OnlineConfig.KEY_TIMESTAMP_GETDATA, System.currentTimeMillis() + "");
                            listener.getDataFinish(errorCode, objData.toString());
                            Yodo1OnlineConfig.this.sendMsg();
                        } else if (errorCode == 10) {
                            YLog.d("[Yodo1OnlineConfig] onYodo1RequestComplete, \u672c\u5730\u53c2\u6570\u5df2\u662f\u6700\u65b0\uff0c\u65e0\u9700\u66f4\u65b0");
                            String onlineconfig = JsonCacheUtils.readJson(context, Yodo1OnlineConfig.KEY_CACHE_FILE_JSON);
                            listener.getDataFinish(errorCode, onlineconfig);
                            Yodo1OnlineConfig.this.sendMsg();
                        } else {
                            String error = jsonObj.optString("error");
                            YLog.d("[Yodo1OnlineConfig] onYodo1RequestComplete, \u83b7\u53d6\u5728\u7ebf\u53c2\u6570\u5f02\u5e38, \u9700\u83b7\u53d6\u9759\u6001\u53c2\u6570, ErrorCode: " + errorCode + ", Error: " + error);
                            time = 0L;
                            Yodo1OnlineConfig.this.getCDNOnlineConfig(listener);
                        }
                    } else {
                        time = 0L;
                        Yodo1OnlineConfig.this.getCDNOnlineConfig(listener);
                    }
                }
                catch (JSONException e) {
                    YLog.d("[Yodo1OnlineConfig] onYodo1RequestComplete, json\u89e3\u6790\u5f02\u5e38, \u9700\u83b7\u53d6\u9759\u6001\u53c2\u6570, message: " + e.getMessage() + ", cause: " + e.getCause());
                    time = 0L;
                    Yodo1OnlineConfig.this.getCDNOnlineConfig(listener);
                }
            }
        });
    }

    public String getConfigParam(String key, String defaultValue) {
        String result = defaultValue;
        try {
            JSONObject obj = this.getJsonData();
            if (obj != null && !TextUtils.isEmpty((CharSequence)obj.optString(key))) {
                result = obj.optString(key);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d("[Yodo1OnlineConfig] getConfigParam " + key + " = " + result);
        return result;
    }

    public void init(Context context, String appKey) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Yodo1OnlineConfig.appKey = appKey;
        Yodo1OnlineConfig.context = context;
        if (TextUtils.isEmpty((CharSequence)ChannelCode)) {
            ChannelCode = Yodo1CommonUtils.getMetedataStr(context, "Yodo1ChannelCode");
            SDKVersion = Yodo1CommonUtils.getMetedataStr(context, "Yodo1SDKVersion");
            SDKTyoe = Yodo1CommonUtils.getMetedataStr(context, "Yodo1SDKType");
        }
        if (TextUtils.isEmpty((CharSequence)ChannelCode)) {
            ChannelCode = "Default";
        }
        YLog.v("*********** Yodo1 Info ***********");
        YLog.v("App Key: " + appKey);
        YLog.d("Publish Channel: " + ChannelCode);
        YLog.v("Sdk Type: " + SDKTyoe);
        YLog.v("Sdk Version: " + SDKVersion);
        YLog.v("*********** Yodo1 Info ***********");
        appPackageName = SysUtils.getPackageName(context);
        appVersionName = SysUtils.getVersionName(context);
        String localAppKey = Yodo1SharedPreferences.getString(context, KEY_GAME_APPK);
        String localAppPackageName = Yodo1SharedPreferences.getString(context, KEY_GAME_PACKAGE_NAME);
        String localAppVersionName = Yodo1SharedPreferences.getString(context, KEY_GAME_VERSION_NAME);
        if (!TextUtils.isEmpty((CharSequence)localAppKey) && !localAppKey.equals(appKey)) {
            Yodo1SharedPreferences.put(context, KEY_DATA_IDENTIFER, "0");
        }
        if (!TextUtils.isEmpty((CharSequence)localAppPackageName) && !localAppPackageName.equals(appPackageName)) {
            Yodo1SharedPreferences.put(context, KEY_DATA_IDENTIFER, "0");
        }
        if (!TextUtils.isEmpty((CharSequence)localAppVersionName) && !localAppVersionName.equals(appVersionName)) {
            Yodo1SharedPreferences.put(context, KEY_DATA_IDENTIFER, "0");
        }
        Yodo1SharedPreferences.put(context, KEY_GAME_APPK, appKey);
        Yodo1SharedPreferences.put(context, KEY_GAME_PACKAGE_NAME, appPackageName);
        Yodo1SharedPreferences.put(context, KEY_GAME_VERSION_NAME, appVersionName);
        Yodo1SharedPreferences.put(context, KEY_GAME_CHANNEL_CODE, ChannelCode);
        Yodo1HttpManage.getInstance().initHttp(context);
    }

    public void initConfig(Context context) {
        Yodo1OnlineConfig.context = context;
        this.getLocation();
    }

    private void getCDNOnlineConfig(final Yodo1OnlineConfigListener listener) {
        this.getCDNOnlineConfig(new Yodo1RequestListener(){

            @Override
            public void onYodo1RequestComplete(Yodo1SDKResponse responseObject) {
                String resMsg = responseObject.getResponseString();
                YLog.d("[Yodo1OnlineConfig] CDN onYodo1RequestComplete, the response string:" + resMsg);
                try {
                    if (resMsg != null) {
                        JSONObject jsonObj = new JSONObject(resMsg.replace(" ", ""));
                        String data_identifer = jsonObj.optString(Yodo1OnlineConfig.KEY_DATA_IDENTIFER);
                        YLog.d("[Yodo1OnlineConfig] CDN onYodo1RequestComplete data_identifer : " + data_identifer);
                        String location_identifer = jsonObj.optString(Yodo1OnlineConfig.KEY_LOCATION_IDENTIFER);
                        YLog.d("[Yodo1OnlineConfig] CDN onYodo1RequestComplete location_identifer : " + location_identifer);
                        String local_data = Yodo1SharedPreferences.getString(context, Yodo1OnlineConfig.KEY_DATA_IDENTIFER);
                        if (TextUtils.isEmpty((CharSequence)local_data)) {
                            local_data = "0";
                        }
                        if (Long.valueOf(data_identifer) > Long.valueOf(local_data)) {
                            JSONObject objData = jsonObj.optJSONObject("data");
                            boolean is_test_model = jsonObj.optBoolean("is_test_model");
                            String device_source = jsonObj.optString("device_source");
                            JSONObject testListObj = jsonObj.optJSONObject("test_list");
                            Yodo1SharedPreferences.put(context, Yodo1OnlineConfig.KEY_ONLINECONFIG_TEST_INFO, testListObj.toString());
                            Yodo1SharedPreferences.put(context, Yodo1OnlineConfig.KEY_ONLINECONFIG_TESTDEVICE, is_test_model);
                            Yodo1SharedPreferences.put(context, Yodo1OnlineConfig.KEY_ONLINECONFIG_TESTDEVICE_SOURCE, device_source);
                            Yodo1SharedPreferences.put(context, Yodo1OnlineConfig.KEY_DATA_IDENTIFER, data_identifer);
                            JsonCacheUtils.writeJson(context, objData, Yodo1OnlineConfig.KEY_CACHE_FILE_JSON);
                            listener.getDataFinish(0, objData.toString());
                        } else {
                            String onlineconfig = JsonCacheUtils.readJson(context, Yodo1OnlineConfig.KEY_CACHE_FILE_JSON);
                            listener.getDataFinish(0, onlineconfig);
                        }
                        Yodo1OnlineConfig.this.sendMsg();
                    } else {
                        listener.getDataFinish(-1, "");
                    }
                }
                catch (JSONException e) {
                    YLog.d("[Yodo1OnlineConfig] CDN onYodo1RequestComplete, json\u89e3\u6790\u5f02\u5e38, message: " + e.getMessage() + ", cause: " + e.getCause());
                    listener.getDataFinish(-1, "");
                }
            }
        });
    }

    private void getCDNOnlineConfig(final Yodo1RequestListener listener) {
        String url = URL_ONLINECONFIG_CDN + MD5EncodeUtil.MD5Encode(appKey) + ".json";
        Request<String> request = NoHttp.createStringRequest(url);
        YLog.d("[Yodo1OnlineConfig] Connecting to the CDN configuration, the request url: " + request.url());
        Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>(){

            @Override
            public void onSucceed(int what, Response<String> response) {
                YLog.d("[Yodo1OnlineConfig] Connect CDN configuration onSucceed, the response: " + response.get());
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(0, response);
                listener.onYodo1RequestComplete(resp);
            }

            @Override
            public void onFailed(int what, Response<String> response) {
                YLog.d("[Yodo1OnlineConfig] Connect CDN configuration onFailed");
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(0, response);
                listener.onYodo1RequestComplete(resp);
            }
        }, false);
    }

    private void getLocation() {
        try {
            String[] permissions1 = new String[]{"android.permission.ACCESS_COARSE_LOCATION"};
            String[] permissions2 = new String[]{"android.permission.ACCESS_FINE_LOCATION"};
            boolean permissionCheck = Yodo1PermissonUtils.hasPermissionForManifest(context, permissions1);
            boolean permissionCheck2 = Yodo1PermissonUtils.hasPermissionForManifest(context, permissions2);
            if (permissionCheck || permissionCheck2) {
                boolean permissionCheck3 = Yodo1PermissonUtils.hasPermission(context, permissions1);
                boolean permissionCheck4 = Yodo1PermissonUtils.hasPermission(context, permissions2);
                if (permissionCheck3 || permissionCheck4) {
                    LocationManager locationManager = (LocationManager)context.getSystemService("location");
                    Location location = locationManager.getLastKnownLocation("gps");
                    if (location != null) {
                        YLog.d("[Yodo1OnlineConfig] getLocation \u5f53\u524dGPS\u5b9a\u4f4d\u7ecf\u7eac\u5ea6\u4e3a: getLatitude = " + location.getLatitude() + ", getLongitude = " + location.getLongitude());
                        location_lng = String.format("%.2f", location.getLongitude());
                        location_lat = String.format("%.2f", location.getLatitude());
                    } else {
                        location = locationManager.getLastKnownLocation("network");
                        if (location != null) {
                            YLog.d("[Yodo1OnlineConfig] getLocation \u5f53\u524d\u7f51\u7edc\u5b9a\u4f4d\u7ecf\u7eac\u5ea6\u4e3a: getLatitude = " + location.getLatitude() + ", getLongitude = " + location.getLongitude());
                            location_lng = String.format("%.2f", location.getLongitude());
                            location_lat = String.format("%.2f", location.getLatitude());
                        }
                    }
                } else {
                    YLog.d("[Yodo1OnlineConfig] getLocation \u5f53\u524d\u5e94\u7528\u672a\u6388\u6743\u83b7\u53d6\u5230\u5b9a\u4f4d\u6743\u9650");
                }
            } else {
                YLog.d("[Yodo1OnlineConfig] getLocation Manifest\u4e2d\u7f3a\u5c11 ACCESS_COARSE_LOCATION \u5b9a\u4f4d\u6743\u9650");
            }
        }
        catch (Exception e) {
            YLog.d("[Yodo1OnlineConfig] getLocation \u5f53\u524d\u5b9a\u4f4d\u5f02\u5e38");
        }
    }

    private void sendMsg() {
        YLog.d("[Yodo1OnlineConfig] sendMsg \u83b7\u53d6\u5230\u5728\u7ebf\u53c2\u6570\uff0c\u53d1\u9001\u5e7f\u64ad");
        context.sendBroadcast(new Intent(ONLINECONFIG_ACTION));
    }

    static {
        time = 0L;
        location_lng = "";
        location_lat = "";
    }
}

