/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.tools;

import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.NoHttp;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Pattern;

public class NetUtils {
    private static final String ANDROID_PROVIDER_SETTINGS = "android.provider.Settings";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)::(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)$");
    private static ConnectivityManager sConnectivityManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ConnectivityManager getConnectivityManager() {
        if (sConnectivityManager != null) return sConnectivityManager;
        Class<NetUtils> clazz = NetUtils.class;
        synchronized (NetUtils.class) {
            if (sConnectivityManager != null) return sConnectivityManager;
            sConnectivityManager = (ConnectivityManager)NoHttp.getContext().getSystemService("connectivity");
            // ** MonitorExit[var0] (shouldn't be in output)
            return sConnectivityManager;
        }
    }

    public static void openSetting() {
        if (Build.VERSION.SDK_INT > 10) {
            NetUtils.openSetting("ACTION_WIFI_SETTINGS");
        } else {
            NetUtils.openSetting("ACTION_WIRELESS_SETTINGS");
        }
    }

    private static void openSetting(String actionName) {
        Intent settingIntent = new Intent(actionName);
        settingIntent.addFlags(0x10000000);
        NoHttp.getContext().startActivity(settingIntent);
    }

    public static boolean isNetworkAvailable() {
        return NetUtils.isNetworkAvailable(NetType.Any);
    }

    public static boolean isWifiConnected() {
        return NetUtils.isNetworkAvailable(NetType.Wifi);
    }

    public static boolean isMobileConnected() {
        return NetUtils.isNetworkAvailable(NetType.Mobile);
    }

    public static boolean isNetworkAvailable(NetType netType) {
        NetUtils.getConnectivityManager();
        if (Build.VERSION.SDK_INT >= 21) {
            Network[] networkArray;
            for (Network network : networkArray = sConnectivityManager.getAllNetworks()) {
                NetworkInfo networkInfo = sConnectivityManager.getNetworkInfo(network);
                if (!NetUtils.isConnected(netType, networkInfo)) continue;
                return true;
            }
        } else {
            NetworkInfo[] networkInfoArray;
            for (NetworkInfo networkInfo : networkInfoArray = sConnectivityManager.getAllNetworkInfo()) {
                if (!NetUtils.isConnected(netType, networkInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isConnected(NetType netType, NetworkInfo networkInfo) {
        switch (netType) {
            case Any: {
                return networkInfo != null && NetUtils.isConnected(networkInfo);
            }
            case Wifi: {
                return networkInfo != null && networkInfo.getType() == 1 && NetUtils.isConnected(networkInfo);
            }
            case Mobile: {
                return networkInfo != null && networkInfo.getType() == 0 && NetUtils.isConnected(networkInfo);
            }
        }
        return false;
    }

    private static boolean isConnected(NetworkInfo networkInfo) {
        return networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected();
    }

    public static boolean isGPRSOpen() {
        NetUtils.getConnectivityManager();
        Class<?> cmClass = sConnectivityManager.getClass();
        try {
            Method getMobileDataEnabledMethod = cmClass.getMethod("getMobileDataEnabled", new Class[0]);
            getMobileDataEnabledMethod.setAccessible(true);
            return (Boolean)getMobileDataEnabledMethod.invoke((Object)sConnectivityManager, new Object[0]);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void setGPRSEnable(boolean isEnable) {
        NetUtils.getConnectivityManager();
        Class<?> cmClass = sConnectivityManager.getClass();
        try {
            Method setMobileDataEnabledMethod = cmClass.getMethod("setMobileDataEnabled", Boolean.TYPE);
            setMobileDataEnabledMethod.setAccessible(true);
            setMobileDataEnabledMethod.invoke((Object)sConnectivityManager, isEnable);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getLocalIPAddress() {
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            Logger.w(e);
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                NetworkInterface nif = enumeration.nextElement();
                Enumeration<InetAddress> inetAddresses = nif.getInetAddresses();
                if (inetAddresses == null) continue;
                while (inetAddresses.hasMoreElements()) {
                    InetAddress ip = inetAddresses.nextElement();
                    if (ip.isLoopbackAddress() || !NetUtils.isIPv4Address(ip.getHostAddress())) continue;
                    return ip.getHostAddress();
                }
            }
        }
        return "";
    }

    public static boolean isIPv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6StdAddress(String input) {
        return IPV6_STD_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6HexCompressedAddress(String input) {
        int colonCount = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != ':') continue;
            ++colonCount;
        }
        return colonCount <= 7 && IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6Address(String input) {
        return NetUtils.isIPv6StdAddress(input) || NetUtils.isIPv6HexCompressedAddress(input);
    }

    public static enum NetType {
        Any,
        Wifi,
        Mobile;

    }
}

