/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.tools;

import android.text.TextUtils;
import com.yodo1.nohttp.Headers;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class HeaderUtils {
    public static final String FORMAT_HTTP_DATA = "EEE, dd MMM y HH:mm:ss 'GMT'";
    public static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static String acceptLanguageInstance;

    public static long parseGMTToMillis(String gmtTime) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_HTTP_DATA, Locale.US);
        formatter.setTimeZone(GMT_TIME_ZONE);
        Date date = formatter.parse(gmtTime);
        return date.getTime();
    }

    public static String formatMillisToGMT(long milliseconds) {
        Date date = new Date(milliseconds);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_HTTP_DATA, Locale.US);
        simpleDateFormat.setTimeZone(GMT_TIME_ZONE);
        return simpleDateFormat.format(date);
    }

    public static long getMaxExpiryMillis() {
        return System.currentTimeMillis() + 3153600000000L;
    }

    public static String systemAcceptLanguage() {
        if (TextUtils.isEmpty((CharSequence)acceptLanguageInstance)) {
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            StringBuilder acceptLanguageBuilder = new StringBuilder(language);
            if (!TextUtils.isEmpty((CharSequence)country)) {
                acceptLanguageBuilder.append('-').append(country).append(',').append(language);
            }
            acceptLanguageInstance = acceptLanguageBuilder.toString();
        }
        return acceptLanguageInstance;
    }

    public static String parseHeadValue(String content, String key, String defaultValue) {
        if (!TextUtils.isEmpty((CharSequence)content) && !TextUtils.isEmpty((CharSequence)key)) {
            StringTokenizer stringTokenizer = new StringTokenizer(content, ";");
            while (stringTokenizer.hasMoreElements()) {
                String name;
                String valuePair = stringTokenizer.nextToken();
                int index = valuePair.indexOf(61);
                if (index <= 0 || !key.equalsIgnoreCase(name = valuePair.substring(0, index).trim())) continue;
                defaultValue = valuePair.substring(index + 1).trim();
                break;
            }
        }
        return defaultValue;
    }

    public static boolean isGzipContent(String contentEncoding) {
        return contentEncoding != null && contentEncoding.contains("gzip");
    }

    public static long getLocalExpires(Headers responseHeaders) {
        long now = System.currentTimeMillis();
        long date = responseHeaders.getDate();
        long expires = responseHeaders.getExpiration();
        long maxAge = 0L;
        long staleWhileRevalidate = 0L;
        String cacheControl = responseHeaders.getCacheControl();
        if (!TextUtils.isEmpty((CharSequence)cacheControl)) {
            StringTokenizer tokens = new StringTokenizer(cacheControl, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim().toLowerCase(Locale.getDefault());
                if (token.equals("no-cache") || token.equals("no-store")) {
                    return 0L;
                }
                if (token.startsWith("max-age=")) {
                    try {
                        maxAge = Long.parseLong(token.substring(8));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!token.startsWith("stale-while-revalidate=")) continue;
                try {
                    staleWhileRevalidate = Long.parseLong(token.substring(23));
                }
                catch (Exception exception) {}
            }
        }
        long localExpire = 0L;
        if (!TextUtils.isEmpty((CharSequence)cacheControl)) {
            localExpire = now + maxAge * 1000L;
            if (staleWhileRevalidate > 0L) {
                localExpire += staleWhileRevalidate * 1000L;
            }
        }
        if ((localExpire == 0L || localExpire == now) && date > 0L && expires >= date) {
            localExpire = now + (expires - date);
        }
        return localExpire;
    }
}

