/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.tools;

import com.yodo1.nohttp.Logger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class Encryption {
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;

    public Encryption(String strKey) {
        try {
            Key key = this.getKey(strKey.getBytes());
            this.encryptCipher = Cipher.getInstance("DES");
            this.encryptCipher.init(1, key);
            this.decryptCipher = Cipher.getInstance("DES");
            this.decryptCipher.init(2, key);
        }
        catch (Exception e) {
            Logger.e(e);
        }
    }

    public static String byteArrayToHexStr(byte[] byteArray) throws Exception {
        int len = byteArray.length;
        StringBuffer sb = new StringBuffer(len * 2);
        for (int i = 0; i < len; ++i) {
            int intTmp;
            for (intTmp = byteArray[i]; intTmp < 0; intTmp += 256) {
            }
            if (intTmp < 16) {
                sb.append("0");
            }
            sb.append(Integer.toString(intTmp, 16));
        }
        return sb.toString();
    }

    public static byte[] hexStrToByteArray(String hexString) throws Exception {
        byte[] byteArrayIn = hexString.getBytes();
        int iLen = byteArrayIn.length;
        byte[] byteArrayOut = new byte[iLen / 2];
        for (int i = 0; i < iLen; i += 2) {
            String strTmp = new String(byteArrayIn, i, 2);
            byteArrayOut[i / 2] = (byte)Integer.parseInt(strTmp, 16);
        }
        return byteArrayOut;
    }

    public static String getMD5ForString(String content) {
        StringBuilder md5Buffer = new StringBuilder();
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] tempBytes = digest.digest(content.getBytes());
            for (int i = 0; i < tempBytes.length; ++i) {
                int digital = tempBytes[i];
                if (digital < 0) {
                    digital += 256;
                }
                if (digital < 16) {
                    md5Buffer.append("0");
                }
                md5Buffer.append(Integer.toHexString(digital));
            }
        }
        catch (NoSuchAlgorithmException e) {
            Logger.e(e);
        }
        return md5Buffer.toString();
    }

    public String encrypt(String encryptionText) throws Exception {
        return Encryption.byteArrayToHexStr(this.encrypt(encryptionText.getBytes()));
    }

    public byte[] encrypt(byte[] byteArray) throws Exception {
        return this.encryptCipher.doFinal(byteArray);
    }

    public String decrypt(String cipherText) throws Exception {
        return new String(this.decrypt(Encryption.hexStrToByteArray(cipherText)));
    }

    public byte[] decrypt(byte[] byteArray) throws Exception {
        return this.decryptCipher.doFinal(byteArray);
    }

    private Key getKey(byte[] arrBTmp) throws Exception {
        byte[] arrB = new byte[8];
        for (int i = 0; i < arrBTmp.length && i < arrB.length; ++i) {
            arrB[i] = arrBTmp[i];
        }
        SecretKeySpec key = new SecretKeySpec(arrB, "DES");
        return key;
    }
}

