/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.tools;

import com.yodo1.nohttp.tools.MultiValueMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicMultiValueMap<K, V>
implements MultiValueMap<K, V> {
    private Map<K, List<V>> mSource;

    public BasicMultiValueMap(Map<K, List<V>> source) {
        this.mSource = source;
    }

    @Override
    public void add(K key, V value) {
        if (key != null) {
            if (!this.containsKey(key)) {
                this.mSource.put(key, new ArrayList(1));
            }
            this.mSource.get(key).add(value);
        }
    }

    @Override
    public void add(K key, List<V> values) {
        for (V value : values) {
            this.add(key, value);
        }
    }

    @Override
    public void set(K key, V value) {
        this.remove(key);
        this.add(key, value);
    }

    @Override
    public void set(K key, List<V> values) {
        this.remove(key);
        this.add(key, values);
    }

    @Override
    public List<V> remove(K key) {
        return this.mSource.remove(key);
    }

    @Override
    public void clear() {
        this.mSource.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.mSource.keySet();
    }

    @Override
    public List<V> values() {
        ArrayList<V> allValues = new ArrayList<V>();
        Set<K> keySet = this.keySet();
        for (K key : keySet) {
            allValues.addAll(this.getValues(key));
        }
        return allValues;
    }

    @Override
    public List<V> getValues(K key) {
        return this.mSource.get(key);
    }

    @Override
    public V getValue(K key) {
        List<V> values = this.mSource.get(key);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.mSource.entrySet();
    }

    @Override
    public V getValue(K key, int index) {
        List<V> values = this.getValues(key);
        if (values != null && index < values.size()) {
            return values.get(index);
        }
        return null;
    }

    @Override
    public int size() {
        return this.mSource.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mSource.isEmpty();
    }

    @Override
    public boolean containsKey(K key) {
        return this.mSource.containsKey(key);
    }

    public Map<K, List<V>> getSource() {
        return this.mSource;
    }
}

