/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class CompatSSLSocketFactory
extends SSLSocketFactory {
    private static final String[] PROTOCOL_ARRAY = new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
    private static final X509TrustManager DEFAULT_TRUST_MANAGERS = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };
    private SSLSocketFactory delegate;

    public CompatSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{DEFAULT_TRUST_MANAGERS}, new SecureRandom());
            this.delegate = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError();
        }
    }

    public CompatSSLSocketFactory(SSLSocketFactory factory) {
        this.delegate = factory;
    }

    private static void setSupportProtocolAndCipherSuites(Socket socket) {
        if (socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(PROTOCOL_ARRAY);
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket ssl = this.delegate.createSocket(s, host, port, autoClose);
        CompatSSLSocketFactory.setSupportProtocolAndCipherSuites(ssl);
        return ssl;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket ssl = this.delegate.createSocket(host, port);
        CompatSSLSocketFactory.setSupportProtocolAndCipherSuites(ssl);
        return ssl;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket ssl = this.delegate.createSocket(host, port, localHost, localPort);
        CompatSSLSocketFactory.setSupportProtocolAndCipherSuites(ssl);
        return ssl;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket ssl = this.delegate.createSocket(host, port);
        CompatSSLSocketFactory.setSupportProtocolAndCipherSuites(ssl);
        return ssl;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket ssl = this.delegate.createSocket(address, port, localAddress, localPort);
        CompatSSLSocketFactory.setSupportProtocolAndCipherSuites(ssl);
        return ssl;
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket ssl = this.delegate.createSocket();
        CompatSSLSocketFactory.setSupportProtocolAndCipherSuites(ssl);
        return ssl;
    }
}

