/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.rest;

import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.rest.ProtocolRequest;
import com.yodo1.nohttp.rest.Response;
import java.util.List;
import java.util.Set;

public class RestResponse<T>
implements Response<T> {
    private final boolean isFromCache;
    private final Headers headers;
    private final T result;
    private final long mNetworkMillis;
    private ProtocolRequest<?, T> request;
    private Exception mException;

    public RestResponse(ProtocolRequest<?, T> request, boolean isFromCache, Headers headers, T result, long millis, Exception e) {
        this.request = request;
        this.isFromCache = isFromCache;
        this.headers = headers;
        this.result = result;
        this.mNetworkMillis = millis;
        this.mException = e;
    }

    @Override
    public ProtocolRequest<?, T> request() {
        return this.request;
    }

    @Override
    public int responseCode() {
        return this.headers.getResponseCode();
    }

    @Override
    public boolean isSucceed() {
        return this.mException == null;
    }

    @Override
    public boolean isFromCache() {
        return this.isFromCache;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public Object getTag() {
        return this.request.getTag();
    }

    @Override
    public T get() {
        return this.result;
    }

    @Override
    public Exception getException() {
        return this.mException;
    }

    @Override
    public long getNetworkMillis() {
        return this.mNetworkMillis;
    }

    public String toString() {
        T result;
        StringBuilder builder = new StringBuilder();
        Headers headers = this.getHeaders();
        if (headers != null) {
            Set keys = headers.keySet();
            for (String key : keys) {
                List<String> values = headers.getValues(key);
                for (String value : values) {
                    if (key != null) {
                        builder.append(key).append(": ");
                    }
                    builder.append(value).append("\n");
                }
            }
        }
        if ((result = this.get()) != null) {
            builder.append(result.toString());
        }
        return builder.toString();
    }
}

