/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.rest;

import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import java.lang.ref.WeakReference;
import java.util.concurrent.BlockingQueue;

public abstract class RestRequest<T>
extends Request<T> {
    private int what;
    private WeakReference<OnResponseListener<T>> responseListener;
    private BlockingQueue<?> blockingQueue;

    public RestRequest(String url) {
        this(url, RequestMethod.GET);
    }

    public RestRequest(String url, RequestMethod requestMethod) {
        super(url, requestMethod);
    }

    @Override
    public void onPreResponse(int what, OnResponseListener<T> responseListener) {
        this.what = what;
        this.responseListener = new WeakReference<OnResponseListener<OnResponseListener<T>>>(responseListener);
    }

    @Override
    public int what() {
        return this.what;
    }

    @Override
    public OnResponseListener<T> responseListener() {
        if (this.responseListener != null) {
            return (OnResponseListener)this.responseListener.get();
        }
        return null;
    }

    @Override
    public void setQueue(BlockingQueue<?> queue) {
        this.blockingQueue = queue;
    }

    @Override
    public boolean inQueue() {
        return this.blockingQueue != null && this.blockingQueue.contains(this);
    }

    @Override
    public void cancel() {
        if (this.blockingQueue != null) {
            this.blockingQueue.remove(this);
        }
        super.cancel();
    }
}

