/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.rest;

import android.os.SystemClock;
import com.yodo1.nohttp.BasicRequest;
import com.yodo1.nohttp.Connection;
import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.HttpConnection;
import com.yodo1.nohttp.NetworkExecutor;
import com.yodo1.nohttp.cache.CacheEntity;
import com.yodo1.nohttp.error.NotFoundCacheError;
import com.yodo1.nohttp.rest.CacheMode;
import com.yodo1.nohttp.rest.ProtocolRequest;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.nohttp.rest.RestResponse;
import com.yodo1.nohttp.tools.CacheStore;
import com.yodo1.nohttp.tools.HeaderUtils;
import com.yodo1.nohttp.tools.IOUtils;
import java.io.IOException;

public class RestProtocol {
    private CacheStore<CacheEntity> mCacheStore;
    private HttpConnection mHttpConnection;

    public RestProtocol(CacheStore<CacheEntity> cache, NetworkExecutor executor) {
        this.mCacheStore = cache;
        this.mHttpConnection = new HttpConnection(executor);
    }

    public <T> Response<T> request(ProtocolRequest<?, T> request) {
        long startTime = SystemClock.elapsedRealtime();
        String cacheKey = request.getCacheKey();
        CacheMode cacheMode = request.getCacheMode();
        CacheEntity localCache = this.mCacheStore.get(cacheKey);
        Protocol protocol = this.requestCacheOrNetwork(cacheMode, localCache, request);
        this.analysisCacheAndProtocol(cacheKey, cacheMode, localCache, protocol);
        Object result = null;
        if (protocol.exception == null) {
            try {
                result = request.parseResponse(protocol.headers, protocol.body);
            }
            catch (Exception e) {
                protocol.exception = e;
            }
        }
        return new RestResponse<Object>((ProtocolRequest<?, Object>)request, protocol.fromCache, protocol.headers, result, SystemClock.elapsedRealtime() - startTime, protocol.exception);
    }

    private Protocol requestCacheOrNetwork(CacheMode cacheMode, CacheEntity localCache, ProtocolRequest<?, ?> request) {
        Protocol protocol = null;
        switch (cacheMode) {
            case ONLY_READ_CACHE: {
                protocol = new Protocol();
                if (localCache == null) {
                    protocol.exception = new NotFoundCacheError("The cache mode is ONLY_READ_CACHE, but did not find the cache.");
                    break;
                }
                protocol.headers = localCache.getResponseHeaders();
                Protocol.access$202(protocol, localCache.getData());
                protocol.fromCache = true;
                break;
            }
            case ONLY_REQUEST_NETWORK: {
                protocol = this.getHttpProtocol(request);
                break;
            }
            case NONE_CACHE_REQUEST_NETWORK: {
                if (localCache != null) {
                    protocol = new Protocol();
                    protocol.headers = localCache.getResponseHeaders();
                    Protocol.access$202(protocol, localCache.getData());
                    protocol.fromCache = true;
                    break;
                }
                protocol = this.getHttpProtocol(request);
                break;
            }
            case REQUEST_NETWORK_FAILED_READ_CACHE: {
                this.setRequestCacheHeader(request, localCache);
                protocol = this.getHttpProtocol(request);
                if (protocol.exception == null || localCache == null) break;
                protocol.headers = localCache.getResponseHeaders();
                Protocol.access$202(protocol, localCache.getData());
                protocol.fromCache = true;
                protocol.exception = null;
                break;
            }
            case DEFAULT: {
                if (localCache != null && localCache.getLocalExpire() > System.currentTimeMillis()) {
                    protocol = new Protocol();
                    protocol.headers = localCache.getResponseHeaders();
                    Protocol.access$202(protocol, localCache.getData());
                    protocol.fromCache = true;
                    break;
                }
                this.setRequestCacheHeader(request, localCache);
                protocol = this.getHttpProtocol(request);
            }
        }
        return protocol;
    }

    private void setRequestCacheHeader(BasicRequest<?> request, CacheEntity cacheEntity) {
        if (cacheEntity == null) {
            request.getHeaders().remove("If-None-Match");
            request.getHeaders().remove("If-Modified-Since");
        } else {
            long lastModified;
            Headers headers = cacheEntity.getResponseHeaders();
            String eTag = headers.getETag();
            if (eTag != null) {
                request.getHeaders().set("If-None-Match", eTag);
            }
            if ((lastModified = headers.getLastModified()) > 0L) {
                request.getHeaders().set("If-Modified-Since", HeaderUtils.formatMillisToGMT(lastModified));
            }
        }
    }

    private Protocol getHttpProtocol(BasicRequest<?> request) {
        Protocol result = new Protocol();
        Connection connection = this.mHttpConnection.getConnection(request);
        result.headers = connection.responseHeaders();
        result.exception = connection.exception();
        if (result.exception == null && connection.serverStream() != null) {
            try {
                Protocol.access$202(result, IOUtils.toByteArray(connection.serverStream()));
            }
            catch (IOException e) {
                result.exception = e;
            }
        }
        IOUtils.closeQuietly(connection);
        return result;
    }

    private void analysisCacheAndProtocol(String cacheKey, CacheMode cacheMode, CacheEntity localCache, Protocol result) {
        if (result.exception == null) {
            int responseCode = result.headers.getResponseCode();
            if (result.body == null) {
                Protocol.access$202(result, new byte[0]);
            }
            if (responseCode == 304) {
                if (localCache != null) {
                    result.fromCache = true;
                    result.headers = localCache.getResponseHeaders();
                    result.headers.set("ResponseCode", "304");
                    Protocol.access$202(result, localCache.getData());
                }
            } else if (localCache == null) {
                switch (cacheMode) {
                    case ONLY_READ_CACHE: 
                    case ONLY_REQUEST_NETWORK: {
                        break;
                    }
                    case NONE_CACHE_REQUEST_NETWORK: 
                    case REQUEST_NETWORK_FAILED_READ_CACHE: {
                        long localExpire = HeaderUtils.getLocalExpires(result.headers);
                        localCache = new CacheEntity();
                        localCache.setResponseHeaders(result.headers);
                        localCache.setData(result.body);
                        localCache.setLocalExpire(localExpire);
                        this.mCacheStore.replace(cacheKey, localCache);
                        break;
                    }
                    case DEFAULT: {
                        long localExpire = HeaderUtils.getLocalExpires(result.headers);
                        long lastModify = result.headers.getLastModified();
                        if (localExpire <= 0L && lastModify <= 0L) {
                            return;
                        }
                        localCache = new CacheEntity();
                        localCache.setResponseHeaders(result.headers);
                        localCache.setData(result.body);
                        localCache.setLocalExpire(localExpire);
                        this.mCacheStore.replace(cacheKey, localCache);
                        break;
                    }
                }
            } else if (!result.fromCache) {
                long localExpire = HeaderUtils.getLocalExpires(result.headers);
                localCache.setLocalExpire(localExpire);
                localCache.getResponseHeaders().setAll(result.headers);
                localCache.setData(result.body);
                this.mCacheStore.replace(cacheKey, localCache);
            }
        }
    }

    private static class Protocol {
        private Headers headers;
        private boolean fromCache;
        private byte[] body;
        private Exception exception;

        private Protocol() {
        }

        static /* synthetic */ byte[] access$202(Protocol x0, byte[] x1) {
            x0.body = x1;
            return x1;
        }
    }
}

