/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.rest;

import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.RequestDispatcher;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestQueue {
    private final BlockingQueue<Request<?>> mUnFinishQueue = new LinkedBlockingDeque();
    private final BlockingQueue<Request<?>> mRequestQueue = new PriorityBlockingQueue();
    private AtomicInteger mInteger = new AtomicInteger();
    private RequestDispatcher[] mDispatchers;

    public RequestQueue(int threadPoolSize) {
        this.mDispatchers = new RequestDispatcher[threadPoolSize];
    }

    public void start() {
        this.stop();
        for (int i = 0; i < this.mDispatchers.length; ++i) {
            RequestDispatcher networkDispatcher;
            this.mDispatchers[i] = networkDispatcher = new RequestDispatcher(this.mUnFinishQueue, this.mRequestQueue);
            networkDispatcher.start();
        }
    }

    public <T> void add(int what, Request<T> request, OnResponseListener<T> responseListener) {
        if (request.inQueue()) {
            Logger.w("This request has been in the queue");
        } else {
            request.onPreResponse(what, responseListener);
            request.setQueue(this.mUnFinishQueue);
            request.setSequence(this.mInteger.incrementAndGet());
            this.mUnFinishQueue.add(request);
            this.mRequestQueue.add(request);
        }
    }

    public int unStartSize() {
        return this.mRequestQueue.size();
    }

    public int unFinishSize() {
        return this.mUnFinishQueue.size();
    }

    public void stop() {
        for (RequestDispatcher dispatcher : this.mDispatchers) {
            if (dispatcher == null) continue;
            dispatcher.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelBySign(Object sign) {
        BlockingQueue<Request<?>> blockingQueue = this.mUnFinishQueue;
        synchronized (blockingQueue) {
            for (Request request : this.mUnFinishQueue) {
                request.cancelBySign(sign);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        BlockingQueue<Request<?>> blockingQueue = this.mUnFinishQueue;
        synchronized (blockingQueue) {
            for (Request request : this.mUnFinishQueue) {
                request.cancel();
            }
        }
    }
}

