/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.rest;

import android.os.Process;
import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.rest.Messenger;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.nohttp.rest.SyncRequestExecutor;
import java.util.concurrent.BlockingQueue;

public class RequestDispatcher
extends Thread {
    private final BlockingQueue<Request<?>> mRequestQueue;
    private final BlockingQueue<Request<?>> mUnFinishQueue;
    private volatile boolean mQuit = false;

    public RequestDispatcher(BlockingQueue<Request<?>> unFinishQueue, BlockingQueue<Request<?>> requestQueue) {
        this.mUnFinishQueue = unFinishQueue;
        this.mRequestQueue = requestQueue;
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (!this.mQuit) {
            Request<?> request;
            try {
                request = this.mRequestQueue.take();
            }
            catch (InterruptedException e) {
                if (this.mQuit) {
                    Logger.w("Queue exit, stop blocking.");
                    break;
                }
                Logger.e(e);
                continue;
            }
            if (request.isCanceled()) {
                Logger.d(request.url() + " is canceled.");
                continue;
            }
            int what = request.what();
            OnResponseListener<?> listener = request.responseListener();
            request.start();
            Messenger.prepare(what, listener).start().post();
            Response response = SyncRequestExecutor.INSTANCE.execute(request);
            this.mUnFinishQueue.remove(request);
            if (request.isCanceled()) {
                Logger.d(request.url() + " finish, but it's canceled.");
            } else {
                Messenger.prepare(what, listener).response(response).post();
            }
            request.finish();
            Messenger.prepare(what, listener).finish().post();
        }
    }
}

