/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.rest;

import com.yodo1.nohttp.HandlerDelivery;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Response;

class Messenger<T> {
    private final int what;
    private final OnResponseListener<T> listener;
    private int command;
    private Response<T> response;

    private Messenger(int what, OnResponseListener<T> listener) {
        this.what = what;
        this.listener = listener;
    }

    static <T> Messenger<T> prepare(int what, OnResponseListener<T> listener) {
        return new Messenger<T>(what, listener);
    }

    Messenger<T> start() {
        this.command = -1;
        return this;
    }

    Messenger<T> response(Response<T> response) {
        this.command = -2;
        this.response = response;
        return this;
    }

    Messenger<T> finish() {
        this.command = -3;
        return this;
    }

    void post() {
        if (this.listener == null) {
            return;
        }
        HandlerDelivery.getInstance().post(new Runnable(){

            @Override
            public void run() {
                switch (Messenger.this.command) {
                    case -1: {
                        Messenger.this.listener.onStart(Messenger.this.what);
                        break;
                    }
                    case -2: {
                        if (Messenger.this.response.isSucceed()) {
                            Messenger.this.listener.onSucceed(Messenger.this.what, Messenger.this.response);
                            break;
                        }
                        Messenger.this.listener.onFailed(Messenger.this.what, Messenger.this.response);
                        break;
                    }
                    case -3: {
                        Messenger.this.listener.onFinish(Messenger.this.what);
                        break;
                    }
                }
            }
        });
    }
}

