/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.rest;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.widget.ImageView;
import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.RestRequest;
import java.util.Locale;

public class ImageRequest
extends RestRequest<Bitmap> {
    private static final Object DECODE_LOCK = new Object();
    private final int mMaxWidth;
    private final int mMaxHeight;
    private final Bitmap.Config mDecodeConfig;
    private ImageView.ScaleType mScaleType;

    public ImageRequest(String url, RequestMethod requestMethod, int maxWidth, int maxHeight, Bitmap.Config decodeConfig, ImageView.ScaleType scaleType) {
        super(url, requestMethod);
        this.mMaxWidth = maxWidth;
        this.mMaxHeight = maxHeight;
        this.mDecodeConfig = decodeConfig;
        this.mScaleType = scaleType;
        this.setAccept("image/*");
    }

    private static int getResizedDimension(int maxPrimary, int maxSecondary, int actualPrimary, int actualSecondary, ImageView.ScaleType scaleType) {
        if (maxPrimary == 0 && maxSecondary == 0) {
            return actualPrimary;
        }
        if (scaleType == ImageView.ScaleType.FIT_XY) {
            if (maxPrimary == 0) {
                return actualPrimary;
            }
            return maxPrimary;
        }
        if (maxPrimary == 0) {
            double ratio = (double)maxSecondary / (double)actualSecondary;
            return (int)((double)actualPrimary * ratio);
        }
        if (maxSecondary == 0) {
            return maxPrimary;
        }
        double ratio = (double)actualSecondary / (double)actualPrimary;
        int resized = maxPrimary;
        if (scaleType == ImageView.ScaleType.CENTER_CROP) {
            if ((double)resized * ratio < (double)maxSecondary) {
                resized = (int)((double)maxSecondary / ratio);
            }
            return resized;
        }
        if ((double)resized * ratio > (double)maxSecondary) {
            resized = (int)((double)maxSecondary / ratio);
        }
        return resized;
    }

    public static int findBestSampleSize(int actualWidth, int actualHeight, int desiredWidth, int desiredHeight) {
        double wr = (double)actualWidth / (double)desiredWidth;
        double hr = (double)actualHeight / (double)desiredHeight;
        double ratio = Math.min(wr, hr);
        float n = 1.0f;
        while ((double)(n * 2.0f) <= ratio) {
            n *= 2.0f;
        }
        return (int)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap parseResponse(Headers responseHeaders, byte[] responseBody) throws Exception {
        Object object = DECODE_LOCK;
        synchronized (object) {
            Bitmap bitmap = null;
            if (responseBody != null) {
                try {
                    bitmap = this.doResponse(responseBody);
                }
                catch (OutOfMemoryError e) {
                    String errorMessage = String.format(Locale.US, "Caught OOM for %d byte image, url=%s", responseBody.length, this.url());
                    Logger.e(e, errorMessage);
                }
            }
            return bitmap;
        }
    }

    private Bitmap doResponse(byte[] byteArray) throws OutOfMemoryError {
        Bitmap bitmap;
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        if (this.mMaxWidth == 0 && this.mMaxHeight == 0) {
            decodeOptions.inPreferredConfig = this.mDecodeConfig;
            bitmap = BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)decodeOptions);
        } else {
            decodeOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)decodeOptions);
            int actualWidth = decodeOptions.outWidth;
            int actualHeight = decodeOptions.outHeight;
            int desiredWidth = ImageRequest.getResizedDimension(this.mMaxWidth, this.mMaxHeight, actualWidth, actualHeight, this.mScaleType);
            int desiredHeight = ImageRequest.getResizedDimension(this.mMaxHeight, this.mMaxWidth, actualHeight, actualWidth, this.mScaleType);
            decodeOptions.inJustDecodeBounds = false;
            decodeOptions.inSampleSize = ImageRequest.findBestSampleSize(actualWidth, actualHeight, desiredWidth, desiredHeight);
            Bitmap tempBitmap = BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)decodeOptions);
            if (tempBitmap != null && (tempBitmap.getWidth() > desiredWidth || tempBitmap.getHeight() > desiredHeight)) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)tempBitmap, (int)desiredWidth, (int)desiredHeight, (boolean)true);
                tempBitmap.recycle();
            } else {
                bitmap = tempBitmap;
            }
        }
        return bitmap;
    }
}

