/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.rest;

import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.rest.Messenger;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.nohttp.rest.SyncRequestExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public enum AsyncRequestExecutor {
    INSTANCE;

    private ExecutorService mExecutorService = Executors.newCachedThreadPool();

    public <T> void execute(int what, Request<T> request, OnResponseListener<T> responseListener) {
        request.onPreResponse(what, responseListener);
        this.mExecutorService.execute(new RequestTask(request));
    }

    private static class RequestTask<T>
    implements Runnable {
        private Request<T> request;

        private RequestTask(Request<T> request) {
            this.request = request;
        }

        @Override
        public void run() {
            if (this.request.isCanceled()) {
                Logger.d(this.request.url() + " is canceled.");
                return;
            }
            int what = this.request.what();
            OnResponseListener<T> listener = this.request.responseListener();
            this.request.start();
            Messenger.prepare(what, listener).start().post();
            Response response = SyncRequestExecutor.INSTANCE.execute(this.request);
            if (this.request.isCanceled()) {
                Logger.d(this.request.url() + " finish, but it's canceled.");
            } else {
                Messenger.prepare(what, listener).response(response).post();
            }
            this.request.finish();
            Messenger.prepare(what, listener).finish().post();
        }
    }
}

