/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.download;

import com.yodo1.nohttp.HandlerDelivery;
import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.download.DownloadListener;

public class Messenger {
    private final int what;
    private final DownloadListener listener;
    private int command;
    private Headers headers;
    private long allCount;
    private boolean isResume;
    private long beforeLength;
    private int progress;
    private long fileCount;
    private long speed;
    private Exception exception;
    private String filePath;

    private Messenger(int what, DownloadListener listener) {
        this.what = what;
        this.listener = listener;
    }

    static Messenger prepare(int what, DownloadListener listener) {
        return new Messenger(what, listener);
    }

    Messenger onStart(boolean isResume, long beforeLength, Headers headers, long allCount) {
        this.command = -1;
        this.isResume = isResume;
        this.beforeLength = beforeLength;
        this.headers = headers;
        this.allCount = allCount;
        return this;
    }

    Messenger onProgress(int progress, long fileCount, long speed) {
        this.command = -2;
        this.progress = progress;
        this.fileCount = fileCount;
        this.speed = speed;
        return this;
    }

    Messenger onError(Exception exception) {
        this.command = -3;
        this.exception = exception;
        return this;
    }

    Messenger onCancel() {
        this.command = -4;
        return this;
    }

    Messenger onFinish(String filePath) {
        this.command = -5;
        this.filePath = filePath;
        return this;
    }

    void post() {
        if (this.listener == null) {
            return;
        }
        HandlerDelivery.getInstance().post(new Runnable(){

            @Override
            public void run() {
                switch (Messenger.this.command) {
                    case -1: {
                        Messenger.this.listener.onStart(Messenger.this.what, Messenger.this.isResume, Messenger.this.beforeLength, Messenger.this.headers, Messenger.this.allCount);
                        break;
                    }
                    case -2: {
                        Messenger.this.listener.onProgress(Messenger.this.what, Messenger.this.progress, Messenger.this.fileCount, Messenger.this.speed);
                        break;
                    }
                    case -3: {
                        Messenger.this.listener.onDownloadError(Messenger.this.what, Messenger.this.exception);
                        break;
                    }
                    case -4: {
                        Messenger.this.listener.onCancel(Messenger.this.what);
                        break;
                    }
                    case -5: {
                        Messenger.this.listener.onFinish(Messenger.this.what, Messenger.this.filePath);
                        break;
                    }
                }
            }
        });
    }
}

