/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.download;

import android.text.TextUtils;
import com.yodo1.nohttp.Connection;
import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.HttpConnection;
import com.yodo1.nohttp.NetworkExecutor;
import com.yodo1.nohttp.download.DownloadListener;
import com.yodo1.nohttp.download.DownloadRequest;
import com.yodo1.nohttp.error.NetworkError;
import com.yodo1.nohttp.error.StorageReadWriteError;
import com.yodo1.nohttp.tools.HeaderUtils;
import com.yodo1.nohttp.tools.IOUtils;
import com.yodo1.nohttp.tools.NetUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;

public class Downloader {
    private HttpConnection mHttpConnection;

    public Downloader(NetworkExecutor executor) {
        this.mHttpConnection = new HttpConnection(executor);
    }

    private void validateParam(DownloadRequest downloadRequest, DownloadListener downloadListener) {
        if (downloadRequest == null) {
            throw new IllegalArgumentException("DownloadRequest == null.");
        }
        if (downloadListener == null) {
            throw new IllegalArgumentException("DownloadListener == null.");
        }
    }

    private void validateDevice(String savePathDir) throws Exception {
        if (!NetUtils.isNetworkAvailable()) {
            throw new NetworkError("Network is not available, please check network and permission: INTERNET, ACCESS_WIFI_STATE, ACCESS_NETWORK_STATE.");
        }
        if (!IOUtils.createFolder(savePathDir)) {
            throw new StorageReadWriteError("SD card isn't available, please check SD card and permission: WRITE_EXTERNAL_STORAGE.\nYou must pay attention to Android6.0 RunTime Permissions: https://github.com/yanzhenjie/AndPermission.\nFailed to create folder: " + savePathDir);
        }
    }

    private Connection getConnectionRetry(DownloadRequest downloadRequest) throws Exception {
        Connection connection = this.mHttpConnection.getConnection(downloadRequest);
        Exception exception = connection.exception();
        if (exception != null) {
            throw exception;
        }
        Headers responseHeaders = connection.responseHeaders();
        int responseCode = responseHeaders.getResponseCode();
        if (responseCode == 416) {
            downloadRequest.removeHeader("Range");
            return this.mHttpConnection.getConnection(downloadRequest);
        }
        return connection;
    }

    private String getRealFileName(DownloadRequest request, Headers responseHeaders) throws IOException {
        String fileName = null;
        String contentDisposition = responseHeaders.getContentDisposition();
        if (!TextUtils.isEmpty((CharSequence)contentDisposition) && !TextUtils.isEmpty((CharSequence)(fileName = HeaderUtils.parseHeadValue(contentDisposition, "filename", null)))) {
            try {
                fileName = URLDecoder.decode(fileName, request.getParamsEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (fileName.startsWith("\"") && fileName.endsWith("\"")) {
                fileName = fileName.substring(1, fileName.length() - 1);
            }
        }
        if (TextUtils.isEmpty(fileName)) {
            String url = request.url();
            URI uri = URI.create(url);
            String path = uri.getPath();
            if (TextUtils.isEmpty((CharSequence)path)) {
                fileName = Integer.toString(url.hashCode());
            } else {
                String[] slash = path.split("/");
                fileName = slash[slash.length - 1];
            }
        }
        return fileName;
    }

    /*
     * Exception decompiling
     */
    public void download(int what, DownloadRequest request, DownloadListener downloadListener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

