/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.download;

import com.yodo1.nohttp.BasicRequest;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.able.Queueable;
import com.yodo1.nohttp.download.DownloadListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.concurrent.BlockingQueue;

public class DownloadRequest
extends BasicRequest<DownloadRequest>
implements Queueable {
    public static final int STATUS_RESTART = 0;
    public static final int STATUS_RESUME = 1;
    public static final int STATUS_FINISH = 2;
    private final String mFileDir;
    private final String mFileName;
    private final boolean isRange;
    private final boolean isDeleteOld;
    private int what;
    private WeakReference<DownloadListener> downloadListener;
    private BlockingQueue<?> blockingQueue;

    public DownloadRequest(String url, RequestMethod requestMethod, String fileFolder, boolean isRange, boolean isDeleteOld) {
        this(url, requestMethod, fileFolder, null, isRange, isDeleteOld);
    }

    public DownloadRequest(String url, RequestMethod requestMethod, String fileFolder, String filename, boolean isRange, boolean isDeleteOld) {
        super(url, requestMethod);
        this.mFileDir = fileFolder;
        this.mFileName = filename;
        this.isRange = isRange;
        this.isDeleteOld = isDeleteOld;
    }

    public String getFileDir() {
        return this.mFileDir;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public boolean isRange() {
        return this.isRange;
    }

    public boolean isDeleteOld() {
        return this.isDeleteOld;
    }

    public int checkBeforeStatus() {
        if (this.isRange) {
            try {
                File lastFile = new File(this.mFileDir, this.mFileName);
                if (lastFile.exists() && !this.isDeleteOld) {
                    return 2;
                }
                File tempFile = new File(this.mFileDir, this.mFileName + ".nohttp");
                if (tempFile.exists()) {
                    return 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public void onPreResponse(int what, DownloadListener downloadListener) {
        this.what = what;
        this.downloadListener = new WeakReference<DownloadListener>(downloadListener);
    }

    public int what() {
        return this.what;
    }

    public DownloadListener downloadListener() {
        if (this.downloadListener != null) {
            return (DownloadListener)this.downloadListener.get();
        }
        return null;
    }

    @Override
    public void setQueue(BlockingQueue<?> queue) {
        this.blockingQueue = queue;
    }

    @Override
    public boolean inQueue() {
        return this.blockingQueue != null && this.blockingQueue.contains(this);
    }
}

