/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.download;

import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.download.DownloadDispatcher;
import com.yodo1.nohttp.download.DownloadListener;
import com.yodo1.nohttp.download.DownloadRequest;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadQueue {
    private final BlockingQueue<DownloadRequest> mUnFinishQueue = new LinkedBlockingDeque<DownloadRequest>();
    private final BlockingQueue<DownloadRequest> mDownloadQueue = new PriorityBlockingQueue<DownloadRequest>();
    private AtomicInteger mInteger = new AtomicInteger();
    private DownloadDispatcher[] mDispatchers;

    public DownloadQueue(int threadPoolSize) {
        this.mDispatchers = new DownloadDispatcher[threadPoolSize];
    }

    public void start() {
        this.stop();
        for (int i = 0; i < this.mDispatchers.length; ++i) {
            DownloadDispatcher networkDispatcher;
            this.mDispatchers[i] = networkDispatcher = new DownloadDispatcher(this.mUnFinishQueue, this.mDownloadQueue);
            networkDispatcher.start();
        }
    }

    public void add(int what, DownloadRequest downloadRequest, DownloadListener downloadListener) {
        if (downloadRequest.inQueue()) {
            Logger.w("This request has been in the queue");
        } else {
            downloadRequest.setQueue(this.mUnFinishQueue);
            downloadRequest.onPreResponse(what, downloadListener);
            downloadRequest.setSequence(this.mInteger.incrementAndGet());
            this.mUnFinishQueue.add(downloadRequest);
            this.mDownloadQueue.add(downloadRequest);
        }
    }

    public int unStartSize() {
        return this.mDownloadQueue.size();
    }

    public int unFinishSize() {
        return this.mUnFinishQueue.size();
    }

    public void stop() {
        for (DownloadDispatcher dispatcher : this.mDispatchers) {
            if (dispatcher == null) continue;
            dispatcher.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelBySign(Object sign) {
        BlockingQueue<DownloadRequest> blockingQueue = this.mUnFinishQueue;
        synchronized (blockingQueue) {
            for (DownloadRequest downloadRequest : this.mUnFinishQueue) {
                downloadRequest.cancelBySign(sign);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        BlockingQueue<DownloadRequest> blockingQueue = this.mUnFinishQueue;
        synchronized (blockingQueue) {
            for (DownloadRequest downloadRequest : this.mUnFinishQueue) {
                downloadRequest.cancel();
            }
        }
    }
}

