/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.download;

import android.os.Process;
import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.download.DownloadListener;
import com.yodo1.nohttp.download.DownloadRequest;
import com.yodo1.nohttp.download.Messenger;
import com.yodo1.nohttp.download.SyncDownloadExecutor;
import java.util.concurrent.BlockingQueue;

class DownloadDispatcher
extends Thread {
    private final BlockingQueue<DownloadRequest> mUnFinishQueue;
    private final BlockingQueue<DownloadRequest> mDownloadQueue;
    private boolean mQuit = false;

    public DownloadDispatcher(BlockingQueue<DownloadRequest> unFinishQueue, BlockingQueue<DownloadRequest> downloadQueue) {
        this.mUnFinishQueue = unFinishQueue;
        this.mDownloadQueue = downloadQueue;
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (!this.mQuit) {
            DownloadRequest request;
            try {
                request = this.mDownloadQueue.take();
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                return;
            }
            if (request.isCanceled()) {
                Logger.d(request.url() + " is canceled.");
                continue;
            }
            request.start();
            SyncDownloadExecutor.INSTANCE.execute(request.what(), request, new DownloadListener(){

                @Override
                public void onStart(int what, boolean isResume, long beforeLength, Headers headers, long allCount) {
                    Messenger.prepare(what, request.downloadListener()).onStart(isResume, beforeLength, headers, allCount).post();
                }

                @Override
                public void onDownloadError(int what, Exception exception) {
                    Messenger.prepare(what, request.downloadListener()).onError(exception).post();
                }

                @Override
                public void onProgress(int what, int progress, long fileCount, long speed) {
                    Messenger.prepare(what, request.downloadListener()).onProgress(progress, fileCount, speed).post();
                }

                @Override
                public void onFinish(int what, String filePath) {
                    Messenger.prepare(what, request.downloadListener()).onFinish(filePath).post();
                }

                @Override
                public void onCancel(int what) {
                    Messenger.prepare(what, request.downloadListener()).onCancel().post();
                }
            });
            request.finish();
            this.mUnFinishQueue.remove(request);
        }
    }
}

