/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.db;

import java.util.List;

public class Where {
    private StringBuilder builder = new StringBuilder();

    public Where() {
    }

    public Where(CharSequence columnName, Options op, Object value) {
        this.add(columnName, op, value);
    }

    public static boolean isNumber(Object value) {
        return value != null && (value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Double || value instanceof Float);
    }

    public final Where clear() {
        this.builder.delete(0, this.builder.length());
        return this;
    }

    public final Where append(Object row) {
        this.builder.append(row);
        return this;
    }

    public final Where set(String row) {
        this.clear().append(row);
        return this;
    }

    public final Where isNull(CharSequence columnName) {
        this.builder.append("\"").append(columnName).append("\" ").append("IS ").append("NULL");
        return this;
    }

    private Where addColumnName(CharSequence columnName, Options op) {
        this.builder.append("\"").append(columnName).append("\" ").append(op.toString()).append(' ');
        return this;
    }

    public final Where add(CharSequence columnName, Options op, Object value) {
        if (Options.EQUAL.equals((Object)op) || Options.ThAN_LARGE.equals((Object)op) || Options.THAN_SMALL.equals((Object)op) || Options.NO_EQUAL.equals((Object)op)) {
            this.addColumnName(columnName, op);
            if (Where.isNumber(value)) {
                this.builder.append(value);
            } else {
                this.builder.append("'").append(value).append("'");
            }
        } else if (Options.IN.equals((Object)op) && value instanceof List) {
            this.addColumnName(columnName, op).append(value).in((List)value);
        } else {
            throw new IllegalArgumentException("Value is not supported by the data type");
        }
        return this;
    }

    private <T> Where in(List<T> values) {
        this.builder.append((Object)Options.IN).append(" (");
        String sep = ", ";
        for (T value : values) {
            if (value instanceof CharSequence) {
                this.builder.append("'").append(value).append("'");
            } else if (value instanceof Integer || value instanceof Long || value instanceof Short) {
                this.builder.append(value);
            }
            this.builder.append(sep);
        }
        if (this.builder.lastIndexOf(sep) > 0) {
            this.builder.delete(this.builder.length() - 2, this.builder.length());
        }
        this.builder.append(")");
        return this;
    }

    private Where and() {
        if (this.builder.length() > 0) {
            this.builder.append(" AND ");
        }
        return this;
    }

    public final Where and(CharSequence columnName, Options op, Object value) {
        return this.and().add(columnName, op, value);
    }

    public final Where andNull(CharSequence columnName) {
        return this.and().isNull(columnName);
    }

    public final Where and(Where where) {
        return this.and().append(where);
    }

    private Where or() {
        if (this.builder.length() > 0) {
            this.builder.append(" OR ");
        }
        return this;
    }

    public final Where or(CharSequence columnName, Options op, Object value) {
        return this.or().add(columnName, op, value);
    }

    public final Where orNull(CharSequence columnName) {
        return this.or().isNull(columnName);
    }

    public final Where or(Where where) {
        return this.or().append(where);
    }

    public final Where bracket() {
        return this.insert(0, "(").append(Character.valueOf(')'));
    }

    public final Where insert(int index, CharSequence s) {
        this.builder.insert(index, s);
        return this;
    }

    public final String get() {
        return this.builder.toString();
    }

    public String toString() {
        return this.builder.toString();
    }

    public static enum Options {
        IN("IN"),
        EQUAL("="),
        NO_EQUAL("!="),
        ThAN_LARGE(">"),
        THAN_SMALL("<");

        private String value;

        private Options(String value) {
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

