/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.db;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import com.yodo1.nohttp.db.BasicEntity;
import java.util.List;

public abstract class BaseDao<T extends BasicEntity> {
    private SQLiteOpenHelper liteOpenHelper;

    public BaseDao(SQLiteOpenHelper disk) {
        this.liteOpenHelper = disk;
    }

    protected final SQLiteDatabase getReader() {
        return this.liteOpenHelper.getReadableDatabase();
    }

    protected final SQLiteDatabase getWriter() {
        try {
            return this.liteOpenHelper.getWritableDatabase();
        }
        catch (SQLiteException e) {
            return null;
        }
    }

    protected final void closeDateBase(SQLiteDatabase database) {
        if (database != null && database.isOpen()) {
            database.close();
        }
    }

    protected final void closeCursor(Cursor cursor) {
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
    }

    public final int count() {
        return this.countColumn("_id");
    }

    public final int countColumn(String columnName) {
        return this.count("SELECT COUNT(" + columnName + ") FROM " + this.getTableName());
    }

    public final int count(String sql) {
        SQLiteDatabase database = this.getReader();
        Cursor cursor = database.rawQuery(sql, null);
        int count = 0;
        if (cursor.moveToNext()) {
            count = cursor.getInt(0);
        }
        this.closeCursor(cursor);
        this.closeDateBase(database);
        return count;
    }

    public final boolean deleteAll() {
        return this.delete("1=1");
    }

    public final boolean delete(List<T> ts) {
        StringBuilder where = new StringBuilder("_id").append(" IN(");
        for (BasicEntity t : ts) {
            long id2 = t.getId();
            if (id2 <= 0L) continue;
            where.append(',');
            where.append(id2);
        }
        where.append(')');
        if (',' == where.charAt(6)) {
            where.deleteCharAt(6);
        }
        return this.delete(where.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean delete(String where) {
        SQLiteDatabase database = this.getWriter();
        if (database == null) {
            return false;
        }
        String sql = "DELETE FROM " + this.getTableName() + " WHERE " + where;
        database.beginTransaction();
        try {
            database.execSQL(sql);
            database.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            database.endTransaction();
            this.closeDateBase(database);
        }
    }

    public final List<T> getAll() {
        return this.getList(null, null, null, null);
    }

    public final List<T> getList(String where, String orderBy, String limit, String offset) {
        StringBuilder sqlBuild = new StringBuilder("SELECT ").append("*").append(" FROM ").append(this.getTableName());
        if (!TextUtils.isEmpty((CharSequence)where)) {
            sqlBuild.append(" WHERE ");
            sqlBuild.append(where);
        }
        if (!TextUtils.isEmpty((CharSequence)orderBy)) {
            sqlBuild.append(" ORDER BY ");
            sqlBuild.append(orderBy);
        }
        if (!TextUtils.isEmpty((CharSequence)limit)) {
            sqlBuild.append(" LIMIT ");
            sqlBuild.append(limit);
        }
        if (!TextUtils.isEmpty((CharSequence)limit) && !TextUtils.isEmpty((CharSequence)offset)) {
            sqlBuild.append(" OFFSET ");
            sqlBuild.append(offset);
        }
        return this.getList(sqlBuild.toString());
    }

    protected abstract List<T> getList(String var1);

    public abstract long replace(T var1);

    protected abstract String getTableName();
}

