/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.cookie;

import android.content.Context;
import android.text.TextUtils;
import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.cookie.CookieEntity;
import com.yodo1.nohttp.cookie.CookieEntityDao;
import com.yodo1.nohttp.db.BaseDao;
import com.yodo1.nohttp.db.Where;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DBCookieStore
implements CookieStore {
    private static final int MAX_COOKIE_SIZE = 8888;
    private Lock mLock = new ReentrantLock();
    private BaseDao<CookieEntity> mCookieEntityDao;
    private CookieStoreListener mCookieStoreListener;
    private boolean mEnable = true;

    public DBCookieStore(Context context) {
        this.mCookieEntityDao = new CookieEntityDao(context);
        Where where = new Where("expiry", Where.Options.EQUAL, -1L);
        this.mCookieEntityDao.delete(where.get());
    }

    public CookieStore setCookieStoreListener(CookieStoreListener cookieStoreListener) {
        this.mCookieStoreListener = cookieStoreListener;
        return this;
    }

    public CookieStore setEnable(boolean enable) {
        this.mEnable = enable;
        return this;
    }

    @Override
    public void add(URI uri, HttpCookie cookie) {
        this.mLock.lock();
        try {
            if (this.mEnable && uri != null && cookie != null) {
                uri = this.getEffectiveURI(uri);
                if (this.mCookieStoreListener != null) {
                    this.mCookieStoreListener.onSaveCookie(uri, cookie);
                }
                this.mCookieEntityDao.replace(new CookieEntity(uri, cookie));
                this.trimSize();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HttpCookie> get(URI uri) {
        this.mLock.lock();
        try {
            String path;
            if (uri == null || !this.mEnable) {
                List<HttpCookie> list = Collections.emptyList();
                return list;
            }
            uri = this.getEffectiveURI(uri);
            Where where = new Where();
            String host = uri.getHost();
            if (!TextUtils.isEmpty((CharSequence)host)) {
                String domain;
                Where subWhere = new Where("domain", Where.Options.EQUAL, host).or("domain", Where.Options.EQUAL, "." + host);
                int firstDot = host.indexOf(".");
                int lastDot = host.lastIndexOf(".");
                if (firstDot > 0 && lastDot > firstDot && !TextUtils.isEmpty((CharSequence)(domain = host.substring(firstDot, host.length())))) {
                    subWhere.or("domain", Where.Options.EQUAL, domain);
                }
                where.set(subWhere.get());
            }
            if (!TextUtils.isEmpty((CharSequence)(path = uri.getPath()))) {
                Where subWhere = new Where("path", Where.Options.EQUAL, path).or("path", Where.Options.EQUAL, "/").orNull("path");
                int lastSplit = path.lastIndexOf("/");
                while (lastSplit > 0) {
                    path = path.substring(0, lastSplit);
                    subWhere.or("path", Where.Options.EQUAL, path);
                    lastSplit = path.lastIndexOf("/");
                }
                subWhere.bracket();
                where.and(subWhere);
            }
            where.or("uri", Where.Options.EQUAL, uri.toString());
            List<CookieEntity> cookieList = this.mCookieEntityDao.getList(where.get(), null, null, null);
            ArrayList<HttpCookie> returnedCookies = new ArrayList<HttpCookie>();
            for (CookieEntity cookieEntity : cookieList) {
                if (cookieEntity.isExpired()) continue;
                returnedCookies.add(cookieEntity.toHttpCookie());
            }
            ArrayList<HttpCookie> arrayList = returnedCookies;
            return arrayList;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HttpCookie> getCookies() {
        this.mLock.lock();
        try {
            if (!this.mEnable) {
                List<HttpCookie> list = Collections.emptyList();
                return list;
            }
            ArrayList<HttpCookie> rt = new ArrayList<HttpCookie>();
            List<CookieEntity> cookieEntityList = this.mCookieEntityDao.getAll();
            for (CookieEntity cookieEntity : cookieEntityList) {
                if (cookieEntity.isExpired()) continue;
                rt.add(cookieEntity.toHttpCookie());
            }
            ArrayList<HttpCookie> arrayList = rt;
            return arrayList;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<URI> getURIs() {
        this.mLock.lock();
        try {
            if (!this.mEnable) {
                List<URI> list = Collections.emptyList();
                return list;
            }
            ArrayList<URI> uris = new ArrayList<URI>();
            List<CookieEntity> uriList = this.mCookieEntityDao.getAll();
            for (CookieEntity cookie : uriList) {
                String uri = cookie.getUri();
                if (TextUtils.isEmpty((CharSequence)uri)) continue;
                try {
                    uris.add(new URI(uri));
                }
                catch (Throwable e) {
                    Logger.w(e);
                    this.mCookieEntityDao.delete("uri=" + uri);
                }
            }
            ArrayList<URI> arrayList = uris;
            return arrayList;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(URI uri, HttpCookie httpCookie) {
        this.mLock.lock();
        try {
            String path;
            if (httpCookie == null || !this.mEnable) {
                boolean bl = true;
                return bl;
            }
            if (this.mCookieStoreListener != null) {
                this.mCookieStoreListener.onRemoveCookie(uri, httpCookie);
            }
            Where where = new Where("name", Where.Options.EQUAL, httpCookie.getName());
            String domain = httpCookie.getDomain();
            if (!TextUtils.isEmpty((CharSequence)domain)) {
                where.and("domain", Where.Options.EQUAL, domain);
            }
            if (!TextUtils.isEmpty((CharSequence)(path = httpCookie.getPath()))) {
                if (path.length() > 1 && path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                where.and("path", Where.Options.EQUAL, path);
            }
            boolean bl = this.mCookieEntityDao.delete(where.toString());
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public boolean removeAll() {
        this.mLock.lock();
        try {
            if (!this.mEnable) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.mCookieEntityDao.deleteAll();
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void trimSize() {
        List<CookieEntity> rmList;
        int count = this.mCookieEntityDao.count();
        if (count > 8898 && (rmList = this.mCookieEntityDao.getList(null, null, Integer.toString(count - 8888), null)) != null) {
            this.mCookieEntityDao.delete(rmList);
        }
    }

    private URI getEffectiveURI(URI uri) {
        URI effectiveURI;
        try {
            effectiveURI = new URI("http", uri.getHost(), uri.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            effectiveURI = uri;
        }
        return effectiveURI;
    }

    public static interface CookieStoreListener {
        public void onSaveCookie(URI var1, HttpCookie var2);

        public void onRemoveCookie(URI var1, HttpCookie var2);
    }
}

