/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.cookie;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.yodo1.nohttp.db.BasicSQLHelper;

class CookieSQLHelper
extends BasicSQLHelper {
    static final String TABLE_NAME = "cookies_table";
    static final String URI = "uri";
    static final String NAME = "name";
    static final String VALUE = "value";
    static final String COMMENT = "comment";
    static final String COMMENT_URL = "comment_url";
    static final String DISCARD = "discard";
    static final String DOMAIN = "domain";
    static final String EXPIRY = "expiry";
    static final String PATH = "path";
    static final String PORT_LIST = "port_list";
    static final String SECURE = "secure";
    static final String VERSION = "version";
    private static final String DB_COOKIE_NAME = "_nohttp_cookies_db.db";
    private static final int DB_COOKIE_VERSION = 2;
    private static final String SQL_CREATE_TABLE = "CREATE TABLE cookies_table(_id INTEGER PRIMARY KEY AUTOINCREMENT, uri TEXT, name TEXT, value TEXT, comment TEXT, comment_url TEXT, discard TEXT, domain TEXT, expiry INTEGER, path TEXT, port_list TEXT, secure TEXT, version INTEGER)";
    private static final String SQL_CREATE_UNIQUE_INDEX = "CREATE UNIQUE INDEX cookie_unique_index ON cookies_table(\"name\", \"domain\", \"path\")";
    private static final String SQL_DELETE_TABLE = "DROP TABLE  IF EXISTS cookies_table";

    public CookieSQLHelper(Context context) {
        super(context, DB_COOKIE_NAME, null, 2);
    }

    public void onCreate(SQLiteDatabase db) {
        db.beginTransaction();
        try {
            db.execSQL(SQL_CREATE_TABLE);
            db.execSQL(SQL_CREATE_UNIQUE_INDEX);
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (newVersion != oldVersion) {
            db.beginTransaction();
            try {
                db.execSQL(SQL_DELETE_TABLE);
                db.execSQL(SQL_CREATE_TABLE);
                db.execSQL(SQL_CREATE_UNIQUE_INDEX);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.onUpgrade(db, oldVersion, newVersion);
    }
}

