/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.cookie;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.yodo1.nohttp.cookie.CookieEntity;
import com.yodo1.nohttp.cookie.CookieSQLHelper;
import com.yodo1.nohttp.db.BaseDao;
import java.util.ArrayList;
import java.util.List;

public class CookieEntityDao
extends BaseDao<CookieEntity> {
    public CookieEntityDao(Context context) {
        super(new CookieSQLHelper(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long replace(CookieEntity cookie) {
        SQLiteDatabase database = this.getWriter();
        if (database == null) {
            return -1L;
        }
        database.beginTransaction();
        ContentValues values = new ContentValues();
        values.put("uri", cookie.getUri());
        values.put("name", cookie.getName());
        values.put("value", cookie.getValue());
        values.put("comment", cookie.getComment());
        values.put("comment_url", cookie.getCommentURL());
        values.put("discard", String.valueOf(cookie.isDiscard()));
        values.put("domain", cookie.getDomain());
        values.put("expiry", Long.valueOf(cookie.getExpiry()));
        values.put("path", cookie.getPath());
        values.put("port_list", cookie.getPortList());
        values.put("secure", String.valueOf(cookie.isSecure()));
        values.put("version", Integer.valueOf(cookie.getVersion()));
        try {
            long result = database.replace("cookies_table", null, values);
            database.setTransactionSuccessful();
            long l = result;
            return l;
        }
        catch (Exception e) {
            long l = -1L;
            return l;
        }
        finally {
            database.endTransaction();
            this.closeDateBase(database);
        }
    }

    @Override
    protected List<CookieEntity> getList(String querySql) {
        SQLiteDatabase database = this.getReader();
        ArrayList<CookieEntity> cookies = new ArrayList<CookieEntity>();
        Cursor cursor = database.rawQuery(querySql, null);
        while (!cursor.isClosed() && cursor.moveToNext()) {
            CookieEntity cookie = new CookieEntity();
            cookie.setId(cursor.getInt(cursor.getColumnIndex("_id")));
            cookie.setUri(cursor.getString(cursor.getColumnIndex("uri")));
            cookie.setName(cursor.getString(cursor.getColumnIndex("name")));
            cookie.setValue(cursor.getString(cursor.getColumnIndex("value")));
            cookie.setComment(cursor.getString(cursor.getColumnIndex("comment")));
            cookie.setCommentURL(cursor.getString(cursor.getColumnIndex("comment_url")));
            cookie.setDiscard("true".equals(cursor.getString(cursor.getColumnIndex("discard"))));
            cookie.setDomain(cursor.getString(cursor.getColumnIndex("domain")));
            cookie.setExpiry(cursor.getLong(cursor.getColumnIndex("expiry")));
            cookie.setPath(cursor.getString(cursor.getColumnIndex("path")));
            cookie.setPortList(cursor.getString(cursor.getColumnIndex("port_list")));
            cookie.setSecure("true".equals(cursor.getString(cursor.getColumnIndex("secure"))));
            cookie.setVersion(cursor.getInt(cursor.getColumnIndex("version")));
            cookies.add(cookie);
        }
        this.closeCursor(cursor);
        this.closeDateBase(database);
        return cookies;
    }

    @Override
    protected String getTableName() {
        return "cookies_table";
    }
}

