/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.cache;

import android.content.Context;
import android.text.TextUtils;
import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.cache.CacheEntity;
import com.yodo1.nohttp.tools.CacheStore;
import com.yodo1.nohttp.tools.Encryption;
import com.yodo1.nohttp.tools.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DiskCacheStore
implements CacheStore<CacheEntity> {
    private Lock mLock;
    private Encryption mEncryption;
    private String mCacheDirectory;

    public DiskCacheStore(Context context) {
        this(context.getCacheDir().getAbsolutePath());
    }

    public DiskCacheStore(String cacheDirectory) {
        if (TextUtils.isEmpty((CharSequence)cacheDirectory)) {
            throw new IllegalArgumentException("The cacheDirectory can't be null.");
        }
        this.mLock = new ReentrantLock();
        this.mEncryption = new Encryption(DiskCacheStore.class.getSimpleName());
        this.mCacheDirectory = cacheDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntity get(String key) {
        this.mLock.lock();
        BufferedReader bufferedReader = null;
        try {
            if (TextUtils.isEmpty((CharSequence)key)) {
                CacheEntity cacheEntity = null;
                return cacheEntity;
            }
            File file = new File(this.mCacheDirectory, this.getFileName(key));
            if (!file.exists() || file.isDirectory()) {
                CacheEntity cacheEntity = null;
                return cacheEntity;
            }
            CacheEntity cacheEntity = new CacheEntity();
            bufferedReader = new BufferedReader(new FileReader(file));
            cacheEntity.setResponseHeadersJson(this.decrypt(bufferedReader.readLine()));
            cacheEntity.setDataBase64(this.decrypt(bufferedReader.readLine()));
            cacheEntity.setLocalExpireString(this.decrypt(bufferedReader.readLine()));
            CacheEntity cacheEntity2 = cacheEntity;
            IOUtils.closeQuietly(bufferedReader);
            this.mLock.unlock();
            return cacheEntity2;
        }
        catch (Exception e) {
            IOUtils.delFileOrFolder(new File(this.mCacheDirectory, this.getFileName(key)));
            Logger.e(e);
        }
        finally {
            IOUtils.closeQuietly(bufferedReader);
            this.mLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntity replace(String key, CacheEntity cacheEntity) {
        this.mLock.lock();
        BufferedWriter bufferedWriter = null;
        try {
            if (TextUtils.isEmpty((CharSequence)key) || cacheEntity == null) {
                CacheEntity cacheEntity2 = cacheEntity;
                return cacheEntity2;
            }
            this.initialize();
            File file = new File(this.mCacheDirectory, this.getFileName(key));
            IOUtils.createNewFile(file);
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(this.encrypt(cacheEntity.getResponseHeadersJson()));
            bufferedWriter.newLine();
            bufferedWriter.write(this.encrypt(cacheEntity.getDataBase64()));
            bufferedWriter.newLine();
            bufferedWriter.write(this.encrypt(cacheEntity.getLocalExpireString()));
            bufferedWriter.flush();
            bufferedWriter.close();
            CacheEntity cacheEntity3 = cacheEntity;
            IOUtils.closeQuietly(bufferedWriter);
            this.mLock.unlock();
            return cacheEntity3;
        }
        catch (Exception e) {
            IOUtils.delFileOrFolder(new File(this.mCacheDirectory, this.getFileName(key)));
            Logger.e(e);
            CacheEntity cacheEntity4 = null;
            return cacheEntity4;
        }
        finally {
            IOUtils.closeQuietly(bufferedWriter);
            this.mLock.unlock();
        }
    }

    @Override
    public boolean remove(String key) {
        this.mLock.lock();
        try {
            boolean bl = IOUtils.delFileOrFolder(new File(this.mCacheDirectory, this.getFileName(key)));
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public boolean clear() {
        this.mLock.lock();
        try {
            boolean bl = IOUtils.delFileOrFolder(this.mCacheDirectory);
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    private boolean initialize() {
        return IOUtils.createFolder(this.mCacheDirectory);
    }

    private String getFileName(String cacheKey) {
        return Encryption.getMD5ForString(cacheKey) + ".nohttp";
    }

    private String encrypt(String encryptionText) throws Exception {
        return this.mEncryption.encrypt(encryptionText);
    }

    private String decrypt(String cipherText) throws Exception {
        return this.mEncryption.decrypt(cipherText);
    }
}

