/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.cache;

import android.content.Context;
import com.yodo1.nohttp.cache.CacheEntity;
import com.yodo1.nohttp.cache.CacheEntityDao;
import com.yodo1.nohttp.db.BaseDao;
import com.yodo1.nohttp.db.Where;
import com.yodo1.nohttp.tools.CacheStore;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DBCacheStore
implements CacheStore<CacheEntity> {
    private Lock mLock = new ReentrantLock();
    private BaseDao<CacheEntity> mManager;
    private boolean mEnable = true;

    public DBCacheStore(Context context) {
        this.mManager = new CacheEntityDao(context);
    }

    public CacheStore<CacheEntity> setEnable(boolean enable) {
        this.mEnable = enable;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntity get(String key) {
        this.mLock.lock();
        try {
            if (!this.mEnable) {
                CacheEntity cacheEntity = null;
                return cacheEntity;
            }
            Where where = new Where("key", Where.Options.EQUAL, key);
            List<CacheEntity> cacheEntities = this.mManager.getList(where.get(), null, null, null);
            CacheEntity cacheEntity = cacheEntities.size() > 0 ? cacheEntities.get(0) : null;
            return cacheEntity;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntity replace(String key, CacheEntity cacheEntity) {
        this.mLock.lock();
        try {
            if (!this.mEnable) {
                CacheEntity cacheEntity2 = cacheEntity;
                return cacheEntity2;
            }
            cacheEntity.setKey(key);
            this.mManager.replace(cacheEntity);
            CacheEntity cacheEntity3 = cacheEntity;
            return cacheEntity3;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String key) {
        this.mLock.lock();
        try {
            if (key == null || !this.mEnable) {
                boolean bl = false;
                return bl;
            }
            Where where = new Where("key", Where.Options.EQUAL, key);
            boolean bl = this.mManager.delete(where.toString());
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public boolean clear() {
        this.mLock.lock();
        try {
            if (!this.mEnable) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.mManager.deleteAll();
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }
}

