/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp.cache;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Base64;
import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.cache.CacheEntity;
import com.yodo1.nohttp.cache.CacheSQLHelper;
import com.yodo1.nohttp.cache.DBCacheStore;
import com.yodo1.nohttp.db.BaseDao;
import com.yodo1.nohttp.tools.Encryption;
import java.util.ArrayList;
import java.util.List;

public class CacheEntityDao
extends BaseDao<CacheEntity> {
    private Encryption mEncryption;
    private String encryptionKey = DBCacheStore.class.getSimpleName();

    public CacheEntityDao(Context context) {
        super(new CacheSQLHelper(context));
        this.mEncryption = new Encryption(this.encryptionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long replace(CacheEntity cacheEntity) {
        SQLiteDatabase database = this.getWriter();
        if (database == null) {
            return -1L;
        }
        database.beginTransaction();
        try {
            ContentValues values = new ContentValues();
            values.put("key", cacheEntity.getKey());
            values.put("head", this.encrypt(cacheEntity.getResponseHeadersJson()));
            values.put("data", this.encrypt(Base64.encodeToString((byte[])cacheEntity.getData(), (int)0)));
            values.put("local_expires", this.encrypt(Long.toString(cacheEntity.getLocalExpire())));
            long result = database.replace(this.getTableName(), null, values);
            database.setTransactionSuccessful();
            long l = result;
            return l;
        }
        catch (Exception e) {
            long l = -1L;
            return l;
        }
        finally {
            database.endTransaction();
            this.closeDateBase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<CacheEntity> getList(String querySql) {
        SQLiteDatabase database = this.getReader();
        ArrayList<CacheEntity> cacheEntities = new ArrayList<CacheEntity>();
        Cursor cursor = null;
        try {
            cursor = database.rawQuery(querySql, null);
            while (!cursor.isClosed() && cursor.moveToNext()) {
                CacheEntity cacheEntity = new CacheEntity();
                cacheEntity.setId(cursor.getInt(cursor.getColumnIndex("_id")));
                cacheEntity.setKey(cursor.getString(cursor.getColumnIndex("key")));
                cacheEntity.setResponseHeadersJson(this.decrypt(cursor.getString(cursor.getColumnIndex("head"))));
                cacheEntity.setData(Base64.decode((String)this.decrypt(cursor.getString(cursor.getColumnIndex("data"))), (int)0));
                cacheEntity.setLocalExpire(Long.parseLong(this.decrypt(cursor.getString(cursor.getColumnIndex("local_expires")))));
                cacheEntities.add(cacheEntity);
            }
        }
        catch (Exception e) {
            Logger.e(e);
        }
        finally {
            this.closeCursor(cursor);
            this.closeDateBase(database);
        }
        return cacheEntities;
    }

    @Override
    protected String getTableName() {
        return "cache_table";
    }

    private String encrypt(String encryptionText) throws Exception {
        return this.mEncryption.encrypt(encryptionText);
    }

    private String decrypt(String cipherText) throws Exception {
        return this.mEncryption.decrypt(cipherText);
    }
}

