/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp;

import android.os.Build;
import com.yodo1.nohttp.BasicRequest;
import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.Network;
import com.yodo1.nohttp.NetworkExecutor;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.URLConnectionNetwork;
import com.yodo1.nohttp.tools.HeaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class URLConnectionNetworkExecutor
implements NetworkExecutor {
    public static InputStream getServerStream(int responseCode, String contentEncoding, HttpURLConnection urlConnection) throws IOException {
        if (responseCode >= 400) {
            return URLConnectionNetworkExecutor.getErrorStream(contentEncoding, urlConnection);
        }
        return URLConnectionNetworkExecutor.getInputStream(contentEncoding, urlConnection);
    }

    private static InputStream getInputStream(String contentEncoding, HttpURLConnection urlConnection) throws IOException {
        InputStream inputStream = urlConnection.getInputStream();
        return URLConnectionNetworkExecutor.gzipInputStream(contentEncoding, inputStream);
    }

    private static InputStream getErrorStream(String contentEncoding, HttpURLConnection urlConnection) throws IOException {
        InputStream inputStream = urlConnection.getErrorStream();
        return URLConnectionNetworkExecutor.gzipInputStream(contentEncoding, inputStream);
    }

    private static InputStream gzipInputStream(String contentEncoding, InputStream inputStream) throws IOException {
        if (HeaderUtils.isGzipContent(contentEncoding)) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public Network execute(BasicRequest request) throws Exception {
        URL url = new URL(request.url());
        Proxy proxy = request.getProxy();
        HttpURLConnection connection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
        connection.setConnectTimeout(request.getConnectTimeout());
        connection.setReadTimeout(request.getReadTimeout());
        connection.setInstanceFollowRedirects(false);
        if (connection instanceof HttpsURLConnection) {
            HostnameVerifier hostnameVerifier;
            SSLSocketFactory sslSocketFactory = request.getSSLSocketFactory();
            if (sslSocketFactory != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(sslSocketFactory);
            }
            if ((hostnameVerifier = request.getHostnameVerifier()) != null) {
                ((HttpsURLConnection)connection).setHostnameVerifier(hostnameVerifier);
            }
        }
        connection.setRequestMethod(request.getRequestMethod().toString());
        connection.setDoInput(true);
        boolean isAllowBody = this.isAllowBody(request.getRequestMethod());
        connection.setDoOutput(isAllowBody);
        Headers headers = request.getHeaders();
        List<String> values = headers.getValues("Connection");
        if (values == null || values.size() == 0) {
            headers.set("Connection", Build.VERSION.SDK_INT > 19 ? "keep-alive" : "close");
        }
        if (isAllowBody) {
            long contentLength = request.getContentLength();
            if (contentLength <= Integer.MAX_VALUE) {
                connection.setFixedLengthStreamingMode((int)contentLength);
            } else if (Build.VERSION.SDK_INT >= 19) {
                connection.setFixedLengthStreamingMode(contentLength);
            } else {
                connection.setChunkedStreamingMode(262144);
            }
            headers.set("Content-Length", Long.toString(contentLength));
        }
        Map<String, String> requestHeaders = headers.toRequestHeaders();
        for (Map.Entry<String, String> headerEntry : requestHeaders.entrySet()) {
            String headKey = headerEntry.getKey();
            String headValue = headerEntry.getValue();
            Logger.i(headKey + ": " + headValue);
            connection.setRequestProperty(headKey, headValue);
        }
        connection.connect();
        return new URLConnectionNetwork(connection);
    }

    private boolean isAllowBody(RequestMethod requestMethod) {
        boolean allowRequestBody = requestMethod.allowRequestBody();
        if (Build.VERSION.SDK_INT < 21) {
            return allowRequestBody && requestMethod != RequestMethod.DELETE;
        }
        return allowRequestBody;
    }
}

