/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.widget.ImageView;
import com.yodo1.nohttp.InitializationConfig;
import com.yodo1.nohttp.NetworkExecutor;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.cache.CacheEntity;
import com.yodo1.nohttp.download.DownloadQueue;
import com.yodo1.nohttp.download.DownloadRequest;
import com.yodo1.nohttp.rest.ByteArrayRequest;
import com.yodo1.nohttp.rest.ImageRequest;
import com.yodo1.nohttp.rest.JsonArrayRequest;
import com.yodo1.nohttp.rest.JsonObjectRequest;
import com.yodo1.nohttp.rest.ProtocolRequest;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.RequestQueue;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.nohttp.rest.StringRequest;
import com.yodo1.nohttp.rest.SyncRequestExecutor;
import com.yodo1.nohttp.tools.CacheStore;
import java.net.CookieManager;
import java.net.CookieStore;
import org.json.JSONArray;
import org.json.JSONObject;

public class NoHttp {
    @SuppressLint(value={"StaticFieldLeak"})
    private static InitializationConfig sInitializeConfig;
    private static RequestQueue sRequestQueueInstance;
    private static DownloadQueue sDownloadQueueInstance;

    private NoHttp() {
    }

    public static void initialize(Context context) {
        sInitializeConfig = InitializationConfig.newBuilder(context).build();
    }

    @Deprecated
    public static void initialize(Context context, Config config) {
        sInitializeConfig = InitializationConfig.newBuilder(context).connectionTimeout(config.mConnectTimeout).readTimeout(config.mReadTimeout).cookieStore(config.mCookieStore).cacheStore(config.mCacheStore).networkExecutor(config.mNetworkExecutor).build();
    }

    public static void initialize(InitializationConfig initializeConfig) {
        sInitializeConfig = initializeConfig;
    }

    private static void testInitialize() {
        if (sInitializeConfig == null) {
            throw new ExceptionInInitializerError("Please invoke NoHttp.initialize(Application) on Application#onCreate()");
        }
    }

    public static Context getContext() {
        NoHttp.testInitialize();
        return sInitializeConfig.getContext();
    }

    public static InitializationConfig getInitializeConfig() {
        NoHttp.testInitialize();
        return sInitializeConfig;
    }

    @Deprecated
    public static int getConnectTimeout() {
        return sInitializeConfig.getConnectTimeout();
    }

    @Deprecated
    public static int getReadTimeout() {
        return sInitializeConfig.getReadTimeout();
    }

    @Deprecated
    public static CookieManager getCookieManager() {
        return sInitializeConfig.getCookieManager();
    }

    @Deprecated
    public static CacheStore<CacheEntity> getCacheStore() {
        return sInitializeConfig.getCacheStore();
    }

    @Deprecated
    public static NetworkExecutor getNetworkExecutor() {
        return sInitializeConfig.getNetworkExecutor();
    }

    public static RequestQueue newRequestQueue() {
        return NoHttp.newRequestQueue(3);
    }

    public static RequestQueue newRequestQueue(int threadPoolSize) {
        RequestQueue requestQueue = new RequestQueue(threadPoolSize);
        requestQueue.start();
        return requestQueue;
    }

    public static Request<String> createStringRequest(String url) {
        return new StringRequest(url);
    }

    public static Request<String> createStringRequest(String url, RequestMethod requestMethod) {
        return new StringRequest(url, requestMethod);
    }

    public static Request<JSONObject> createJsonObjectRequest(String url) {
        return new JsonObjectRequest(url);
    }

    public static Request<JSONObject> createJsonObjectRequest(String url, RequestMethod requestMethod) {
        return new JsonObjectRequest(url, requestMethod);
    }

    public static Request<JSONArray> createJsonArrayRequest(String url) {
        return new JsonArrayRequest(url);
    }

    public static Request<JSONArray> createJsonArrayRequest(String url, RequestMethod requestMethod) {
        return new JsonArrayRequest(url, requestMethod);
    }

    public static Request<Bitmap> createImageRequest(String url) {
        return NoHttp.createImageRequest(url, RequestMethod.GET);
    }

    public static Request<Bitmap> createImageRequest(String url, RequestMethod requestMethod) {
        return NoHttp.createImageRequest(url, requestMethod, 1000, 1000, Bitmap.Config.ARGB_8888, ImageView.ScaleType.CENTER_INSIDE);
    }

    public static Request<Bitmap> createImageRequest(String url, RequestMethod requestMethod, int maxWidth, int maxHeight, Bitmap.Config config, ImageView.ScaleType scaleType) {
        return new ImageRequest(url, requestMethod, maxWidth, maxHeight, config, scaleType);
    }

    public static Request<byte[]> createByteArrayRequest(String url) {
        return new ByteArrayRequest(url);
    }

    public static Request<byte[]> createByteArrayRequest(String url, RequestMethod method) {
        return new ByteArrayRequest(url, method);
    }

    public static <T> Response<T> startRequestSync(ProtocolRequest<?, T> request) {
        return SyncRequestExecutor.INSTANCE.execute(request);
    }

    public static DownloadQueue newDownloadQueue() {
        return NoHttp.newDownloadQueue(3);
    }

    public static DownloadQueue newDownloadQueue(int threadPoolSize) {
        DownloadQueue downloadQueue = new DownloadQueue(threadPoolSize);
        downloadQueue.start();
        return downloadQueue;
    }

    public static DownloadRequest createDownloadRequest(String url, String fileFolder, boolean isDeleteOld) {
        return NoHttp.createDownloadRequest(url, RequestMethod.GET, fileFolder, isDeleteOld);
    }

    public static DownloadRequest createDownloadRequest(String url, RequestMethod requestMethod, String fileFolder, boolean isDeleteOld) {
        return new DownloadRequest(url, requestMethod, fileFolder, true, isDeleteOld);
    }

    public static DownloadRequest createDownloadRequest(String url, RequestMethod requestMethod, String fileFolder, boolean isRange, boolean isDeleteOld) {
        return new DownloadRequest(url, requestMethod, fileFolder, true, isDeleteOld);
    }

    public static DownloadRequest createDownloadRequest(String url, String fileFolder, String filename, boolean isRange, boolean isDeleteOld) {
        return NoHttp.createDownloadRequest(url, RequestMethod.GET, fileFolder, filename, isRange, isDeleteOld);
    }

    public static DownloadRequest createDownloadRequest(String url, RequestMethod requestMethod, String fileFolder, String filename, boolean isRange, boolean isDeleteOld) {
        return new DownloadRequest(url, requestMethod, fileFolder, filename, isRange, isDeleteOld);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestQueue getRequestQueueInstance() {
        if (sRequestQueueInstance != null) return sRequestQueueInstance;
        Class<NoHttp> clazz = NoHttp.class;
        synchronized (NoHttp.class) {
            if (sRequestQueueInstance != null) return sRequestQueueInstance;
            sRequestQueueInstance = NoHttp.newRequestQueue();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sRequestQueueInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadQueue getDownloadQueueInstance() {
        if (sDownloadQueueInstance != null) return sDownloadQueueInstance;
        Class<NoHttp> clazz = NoHttp.class;
        synchronized (NoHttp.class) {
            if (sDownloadQueueInstance != null) return sDownloadQueueInstance;
            sDownloadQueueInstance = NoHttp.newDownloadQueue();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDownloadQueueInstance;
        }
    }

    @Deprecated
    public static final class Config {
        private int mConnectTimeout = 10000;
        private int mReadTimeout = 10000;
        private CookieStore mCookieStore;
        private CacheStore<CacheEntity> mCacheStore;
        private NetworkExecutor mNetworkExecutor;

        public Config setConnectTimeout(int timeout) {
            this.mConnectTimeout = timeout;
            return this;
        }

        public Config setReadTimeout(int timeout) {
            this.mReadTimeout = timeout;
            return this;
        }

        public Config setCookieStore(CookieStore cookieStore) {
            this.mCookieStore = cookieStore;
            return this;
        }

        public Config setCacheStore(CacheStore<CacheEntity> cacheStore) {
            this.mCacheStore = cacheStore;
            return this;
        }

        public Config setNetworkExecutor(NetworkExecutor executor) {
            this.mNetworkExecutor = executor;
            return this;
        }
    }
}

