/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp;

import android.util.Log;
import java.lang.reflect.Method;

public class Logger {
    private static final String V = "v";
    private static final String D = "d";
    private static final String I = "i";
    private static final String W = "w";
    private static final String E = "e";
    private static final String WTF = "wtf";
    private static final int MAX_LENGTH = 3000;
    private static String STag = "NoHttp";
    private static boolean SDebug = false;

    public static void setTag(String tag) {
        STag = tag;
    }

    public static void setDebug(boolean debug) {
        SDebug = debug;
    }

    public static void i(Object msg) {
        Logger.print(I, msg);
    }

    public static void i(Throwable e) {
        Logger.i(e, "");
    }

    public static void i(Throwable e, Object msg) {
        Logger.print(I, msg, e);
    }

    public static void v(Object msg) {
        Logger.print(V, msg);
    }

    public static void v(Throwable e) {
        Logger.v(e, "");
    }

    public static void v(Throwable e, Object msg) {
        Logger.print(V, msg, e);
    }

    public static void d(Object msg) {
        Logger.print(D, msg);
    }

    public static void d(Throwable e) {
        Logger.d(e, "");
    }

    public static void d(Throwable e, Object msg) {
        Logger.print(D, msg, e);
    }

    public static void e(Object msg) {
        Logger.print(E, msg);
    }

    public static void e(Throwable e) {
        Logger.e(e, "");
    }

    public static void e(Throwable e, String msg) {
        Logger.print(E, (Object)msg, e);
    }

    public static void w(String msg) {
        Logger.print(W, msg);
    }

    public static void w(Throwable e) {
        Logger.w(e, "");
    }

    public static void w(Throwable e, String msg) {
        Logger.print(W, (Object)msg, e);
    }

    public static void wtf(String msg) {
        Logger.print(WTF, msg);
    }

    public static void wtf(Throwable e) {
        Logger.wtf(e, "");
    }

    public static void wtf(Throwable e, String msg) {
        Logger.print(WTF, (Object)msg, e);
    }

    private static void print(String method, Object o) {
        Logger.print(method, STag, Logger.toString(o));
    }

    private static String toString(Object o) {
        return o == null ? "null" : o.toString();
    }

    private static void print(String method, String tag, String message) {
        if (SDebug) {
            int strLength = message.length();
            if (strLength == 0) {
                Logger.invokePrint(method, tag, message);
            } else {
                for (int i = 0; i < strLength / 3000 + (strLength % 3000 > 0 ? 1 : 0); ++i) {
                    int end = (i + 1) * 3000;
                    if (strLength >= end) {
                        Logger.invokePrint(method, tag, message.substring(end - 3000, end));
                        continue;
                    }
                    Logger.invokePrint(method, tag, message.substring(end - 3000));
                }
            }
        }
    }

    private static void invokePrint(String method, String tag, String message) {
        try {
            Class<Log> logClass = Log.class;
            Method logMethod = logClass.getMethod(method, String.class, String.class);
            logMethod.setAccessible(true);
            logMethod.invoke(null, tag, message);
        }
        catch (Exception e) {
            System.out.println(tag + ": " + message);
        }
    }

    private static void print(String method, Object o, Throwable e) {
        Logger.print(method, STag, Logger.toString(o), e);
    }

    private static void print(String method, String tag, String message, Throwable e) {
        Logger.invokePrint(method, tag, message, e);
    }

    private static void invokePrint(String method, String tag, String message, Throwable e) {
        if (SDebug) {
            try {
                Class<Log> logClass = Log.class;
                Method logMethod = logClass.getMethod(method, String.class, String.class, Throwable.class);
                logMethod.setAccessible(true);
                logMethod.invoke(null, tag, message, e);
            }
            catch (Exception e1) {
                System.out.println(tag + ": " + message);
            }
        }
    }
}

