/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp;

import android.content.res.AssetManager;
import com.yodo1.nohttp.BasicBinary;
import com.yodo1.nohttp.Logger;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamBinary
extends BasicBinary {
    protected InputStream inputStream;

    public InputStreamBinary(InputStream inputStream, String fileName) {
        this(inputStream, fileName, null);
    }

    public InputStreamBinary(InputStream inputStream, String fileName, String mimeType) {
        super(fileName, mimeType);
        if (inputStream == null) {
            throw new NullPointerException("The inputStream can't be null.");
        }
        if (!(inputStream instanceof FileInputStream || inputStream instanceof ByteArrayInputStream || inputStream instanceof AssetManager.AssetInputStream)) {
            throw new IllegalArgumentException("The inputStream must be FileInputStream, ByteArrayInputStream and AssetInputStream.");
        }
        this.inputStream = inputStream;
    }

    @Override
    public long getBinaryLength() {
        try {
            if (this.inputStream instanceof FileInputStream) {
                return ((FileInputStream)this.inputStream).getChannel().size();
            }
            return this.inputStream.available();
        }
        catch (IOException e) {
            Logger.e(e);
            return 0L;
        }
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return this.inputStream;
    }
}

