/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp;

import android.content.Context;
import com.yodo1.nohttp.NetworkExecutor;
import com.yodo1.nohttp.URLConnectionNetworkExecutor;
import com.yodo1.nohttp.cache.CacheEntity;
import com.yodo1.nohttp.cache.DBCacheStore;
import com.yodo1.nohttp.cookie.DBCookieStore;
import com.yodo1.nohttp.ssl.SSLUtils;
import com.yodo1.nohttp.tools.CacheStore;
import com.yodo1.nohttp.tools.LinkedMultiValueMap;
import com.yodo1.nohttp.tools.MultiValueMap;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public final class InitializationConfig {
    private Context mContext;
    private int mConnectTimeout;
    private int mReadTimeout;
    private int mRetryCount;
    private SSLSocketFactory mSSLSocketFactory;
    private HostnameVerifier mHostnameVerifier;
    private MultiValueMap<String, String> mHeaders;
    private MultiValueMap<String, String> mParams;
    private CookieStore mCookieStore;
    private CookieManager mCookieManager;
    private CacheStore<CacheEntity> mCacheStore;
    private NetworkExecutor mNetworkExecutor;

    private InitializationConfig(Builder builder) {
        this.mContext = builder.mContext;
        this.mConnectTimeout = builder.mConnectTimeout;
        this.mReadTimeout = builder.mReadTimeout;
        this.mRetryCount = builder.mRetryCount;
        this.mSSLSocketFactory = builder.mSSLSocketFactory;
        if (this.mSSLSocketFactory == null) {
            this.mSSLSocketFactory = SSLUtils.defaultSSLSocketFactory();
        }
        this.mHostnameVerifier = builder.mHostnameVerifier;
        if (this.mHostnameVerifier == null) {
            this.mHostnameVerifier = SSLUtils.defaultHostnameVerifier();
        }
        this.mHeaders = builder.mHeaders;
        this.mParams = builder.mParams;
        this.mCookieStore = builder.mCookieStore;
        if (this.mCookieStore == null) {
            this.mCookieStore = new DBCookieStore(this.mContext);
        }
        this.mCookieManager = new CookieManager(this.mCookieStore, CookiePolicy.ACCEPT_ALL);
        this.mCacheStore = builder.mCacheStore;
        if (this.mCacheStore == null) {
            this.mCacheStore = new DBCacheStore(this.mContext);
        }
        this.mNetworkExecutor = builder.mNetworkExecutor;
        if (this.mNetworkExecutor == null) {
            this.mNetworkExecutor = new URLConnectionNetworkExecutor();
        }
    }

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getConnectTimeout() {
        return this.mConnectTimeout;
    }

    public int getReadTimeout() {
        return this.mReadTimeout;
    }

    public int getRetryCount() {
        return this.mRetryCount;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.mSSLSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.mHostnameVerifier;
    }

    public MultiValueMap<String, String> getHeaders() {
        return this.mHeaders;
    }

    public MultiValueMap<String, String> getParams() {
        return this.mParams;
    }

    public CookieStore getCookieStore() {
        return this.mCookieStore;
    }

    public CookieManager getCookieManager() {
        return this.mCookieManager;
    }

    public CacheStore<CacheEntity> getCacheStore() {
        return this.mCacheStore;
    }

    public NetworkExecutor getNetworkExecutor() {
        return this.mNetworkExecutor;
    }

    public static final class Builder {
        private Context mContext;
        private int mConnectTimeout = 10000;
        private int mReadTimeout = 10000;
        private int mRetryCount;
        private SSLSocketFactory mSSLSocketFactory;
        private HostnameVerifier mHostnameVerifier;
        private MultiValueMap<String, String> mHeaders = new LinkedMultiValueMap<String, String>();
        private MultiValueMap<String, String> mParams = new LinkedMultiValueMap<String, String>();
        private CookieStore mCookieStore;
        private CacheStore<CacheEntity> mCacheStore;
        private NetworkExecutor mNetworkExecutor;

        private Builder(Context context) {
            this.mContext = context.getApplicationContext();
        }

        public Builder connectionTimeout(int millis) {
            this.mConnectTimeout = millis;
            return this;
        }

        public Builder readTimeout(int millis) {
            this.mReadTimeout = millis;
            return this;
        }

        public Builder retry(int count) {
            this.mRetryCount = count;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.mSSLSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.mHostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.mHeaders.add(key, value);
            return this;
        }

        public Builder addParam(String key, String value) {
            this.mParams.add(key, value);
            return this;
        }

        public Builder cookieStore(CookieStore cookieStore) {
            this.mCookieStore = cookieStore;
            return this;
        }

        public Builder cacheStore(CacheStore<CacheEntity> cacheStore) {
            this.mCacheStore = cacheStore;
            return this;
        }

        public Builder networkExecutor(NetworkExecutor executor) {
            this.mNetworkExecutor = executor;
            return this;
        }

        public InitializationConfig build() {
            return new InitializationConfig(this);
        }
    }
}

