/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp;

import android.text.TextUtils;
import android.webkit.URLUtil;
import com.yodo1.nohttp.BasicRequest;
import com.yodo1.nohttp.Binary;
import com.yodo1.nohttp.Connection;
import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.Network;
import com.yodo1.nohttp.NetworkExecutor;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RedirectHandler;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.error.NetworkError;
import com.yodo1.nohttp.error.TimeoutError;
import com.yodo1.nohttp.error.URLError;
import com.yodo1.nohttp.error.UnKnownHostError;
import com.yodo1.nohttp.tools.IOUtils;
import com.yodo1.nohttp.tools.MultiValueMap;
import com.yodo1.nohttp.tools.NetUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;

public class HttpConnection {
    private NetworkExecutor mExecutor;

    public HttpConnection(NetworkExecutor executor) {
        this.mExecutor = executor;
    }

    public static boolean hasResponseBody(RequestMethod requestMethod, int responseCode) {
        return requestMethod != RequestMethod.HEAD && HttpConnection.hasResponseBody(responseCode);
    }

    public static boolean hasResponseBody(int responseCode) {
        return !(100 <= responseCode && responseCode < 200 || responseCode == 204 || responseCode == 205 || 300 <= responseCode && responseCode < 400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(BasicRequest<?> request) {
        Logger.d("--------------Request start--------------");
        Headers responseHeaders = new Headers();
        InputStream inputStream = null;
        Exception exception = null;
        Network network = null;
        String url = request.url();
        try {
            if (!NetUtils.isNetworkAvailable()) {
                throw new NetworkError("The network is not available, please check the network. The requested url is: " + url);
            }
            network = this.createConnectionAndWriteData(request);
            Logger.d("-------Response start-------");
            int responseCode = network.getResponseCode();
            responseHeaders = this.parseResponseHeaders(new URI(request.url()), responseCode, network.getResponseHeaders());
            if (responseCode == 301 || responseCode == 302 || responseCode == 303 || responseCode == 307) {
                Connection redirectConnection = this.handleRedirect(request, responseHeaders);
                responseHeaders = redirectConnection.responseHeaders();
                inputStream = redirectConnection.serverStream();
                exception = redirectConnection.exception();
            } else if (HttpConnection.hasResponseBody(request.getRequestMethod(), responseCode)) {
                inputStream = network.getServerStream(responseCode, responseHeaders);
            }
            Logger.d("-------Response end-------");
        }
        catch (MalformedURLException e) {
            exception = new URLError("The url is malformed: " + url + ".");
        }
        catch (UnknownHostException e) {
            exception = new UnKnownHostError("Hostname can not be resolved: " + url + ".");
        }
        catch (SocketTimeoutException e) {
            exception = new TimeoutError("Request time out: " + url + ".");
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                Logger.e(exception);
            }
        }
        Logger.d("--------------Request finish--------------");
        return new Connection(network, responseHeaders, inputStream, exception);
    }

    private Network createConnectionAndWriteData(BasicRequest<?> request) throws Exception {
        Network network = null;
        Exception exception = null;
        boolean failed = true;
        for (int retryCount = request.getRetryCount() + 1; failed && retryCount > 0; --retryCount) {
            try {
                network = this.createNetwork(request);
                exception = null;
                failed = false;
                continue;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (failed) {
            throw exception;
        }
        if (request.getRequestMethod().allowRequestBody()) {
            this.writeRequestBody(request, network.getOutputStream());
        }
        return network;
    }

    private Network createNetwork(BasicRequest<?> request) throws Exception {
        RequestMethod requestMethod;
        request.onPreExecute();
        String url = request.url();
        Logger.i("Request address: " + url);
        Logger.i("Request method: " + (Object)((Object)request.getRequestMethod()));
        Headers headers = request.getHeaders();
        headers.set("Content-Type", request.getContentType());
        List<String> values = headers.getValues("Connection");
        if (values == null || values.size() == 0) {
            headers.add("Connection", "keep-alive");
        }
        if ((requestMethod = request.getRequestMethod()).allowRequestBody()) {
            headers.set("Content-Length", Long.toString(request.getContentLength()));
        }
        headers.addCookie(new URI(url), NoHttp.getCookieManager());
        return this.mExecutor.execute(request);
    }

    private void writeRequestBody(BasicRequest<?> request, OutputStream outputStream) throws IOException {
        Logger.i("-------Send request data start-------");
        BufferedOutputStream realOutputStream = IOUtils.toBufferedOutputStream(outputStream);
        request.onWriteRequestBody(realOutputStream);
        IOUtils.closeQuietly(realOutputStream);
        Logger.i("-------Send request data end-------");
    }

    private Connection handleRedirect(BasicRequest<?> oldRequest, Headers responseHeaders) {
        BasicRequest redirectRequest = null;
        RedirectHandler redirectHandler = oldRequest.getRedirectHandler();
        if (redirectHandler != null) {
            if (redirectHandler.isDisallowedRedirect(responseHeaders)) {
                return new Connection(null, responseHeaders, null, null);
            }
            redirectRequest = redirectHandler.onRedirect(oldRequest, responseHeaders);
        }
        if (redirectRequest == null) {
            String location = responseHeaders.getLocation();
            if (!URLUtil.isNetworkUrl((String)location)) {
                String oldUrl = oldRequest.url();
                try {
                    URL url = new URL(oldUrl);
                    location = url.getProtocol() + "://" + url.getHost() + location;
                }
                catch (MalformedURLException url) {
                    // empty catch block
                }
            }
            redirectRequest = new BasicRequest(location, oldRequest.getRequestMethod()){};
            Headers headers = oldRequest.getHeaders();
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                for (String value : values) {
                    redirectRequest.addHeader(key, value);
                }
            }
            MultiValueMap<String, Object> multiValueMap = oldRequest.getParamKeyValues();
            for (Map.Entry<String, List<Object>> stringListEntry : multiValueMap.entrySet()) {
                String key = stringListEntry.getKey();
                List<Object> values = stringListEntry.getValue();
                for (Object value : values) {
                    if (value instanceof CharSequence) {
                        redirectRequest.add(key, value.toString());
                        continue;
                    }
                    if (!(value instanceof Binary)) continue;
                    redirectRequest.add(key, (Binary)value);
                }
            }
            redirectRequest.setRedirectHandler(oldRequest.getRedirectHandler());
            redirectRequest.setSSLSocketFactory(oldRequest.getSSLSocketFactory());
            redirectRequest.setHostnameVerifier(oldRequest.getHostnameVerifier());
            redirectRequest.setParamsEncoding(oldRequest.getParamsEncoding());
            redirectRequest.setProxy(oldRequest.getProxy());
        }
        return this.getConnection(redirectRequest);
    }

    private Headers parseResponseHeaders(URI uri, int responseCode, Map<String, List<String>> responseHeaders) {
        try {
            NoHttp.getInitializeConfig().getCookieManager().put(uri, responseHeaders);
        }
        catch (IOException e) {
            Logger.e(e, "Save cookie filed: " + uri.toString() + ".");
        }
        Headers headers = new Headers();
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            headers.add(entry.getKey(), entry.getValue());
        }
        headers.set("ResponseCode", Integer.toString(responseCode));
        for (String headKey : headers.keySet()) {
            List<String> headValues = headers.getValues(headKey);
            for (String headValue : headValues) {
                StringBuilder builder = new StringBuilder();
                if (!TextUtils.isEmpty((CharSequence)headKey)) {
                    builder.append(headKey).append(": ");
                }
                if (!TextUtils.isEmpty((CharSequence)headValue)) {
                    builder.append(headValue);
                }
                Logger.i(builder.toString());
            }
        }
        return headers;
    }
}

