/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp;

import android.text.TextUtils;
import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.tools.HeaderUtils;
import com.yodo1.nohttp.tools.TreeMultiValueMap;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.HttpCookie;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Headers
extends TreeMultiValueMap<String, String> {
    public static final String HEAD_KEY_RESPONSE_CODE = "ResponseCode";
    public static final String HEAD_KEY_ACCEPT = "Accept";
    public static final String HEAD_VALUE_ACCEPT_ALL = "application/json,application/xml,application/xhtml+xml,text/html;q=0.9,image/webp,*/*;q=0.8";
    public static final String HEAD_KEY_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEAD_VALUE_ACCEPT_ENCODING_GZIP_DEFLATE = "gzip, deflate";
    public static final String HEAD_KEY_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HEAD_KEY_ACCEPT_RANGE = "Accept-Range";
    public static final String HEAD_KEY_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEAD_KEY_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEAD_KEY_CONTENT_LENGTH = "Content-Length";
    public static final String HEAD_KEY_CONTENT_RANGE = "Content-Range";
    public static final String HEAD_KEY_CONTENT_TYPE = "Content-Type";
    public static final String HEAD_VALUE_CONTENT_TYPE_URLENCODED = "application/x-www-form-urlencoded";
    public static final String HEAD_VALUE_CONTENT_TYPE_FORM_DATA = "multipart/form-data";
    public static final String HEAD_VALUE_CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
    public static final String HEAD_VALUE_CONTENT_TYPE_JSON = "application/json";
    public static final String HEAD_VALUE_CONTENT_TYPE_XML = "application/xml";
    public static final String HEAD_KEY_CACHE_CONTROL = "Cache-Control";
    public static final String HEAD_KEY_CONNECTION = "Connection";
    public static final String HEAD_VALUE_CONNECTION_KEEP_ALIVE = "keep-alive";
    public static final String HEAD_VALUE_CONNECTION_CLOSE = "close";
    public static final String HEAD_KEY_DATE = "Date";
    public static final String HEAD_KEY_EXPIRES = "Expires";
    public static final String HEAD_KEY_E_TAG = "ETag";
    public static final String HEAD_KEY_PRAGMA = "Pragma";
    public static final String HEAD_KEY_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEAD_KEY_IF_NONE_MATCH = "If-None-Match";
    public static final String HEAD_KEY_LAST_MODIFIED = "Last-Modified";
    public static final String HEAD_KEY_LOCATION = "Location";
    public static final String HEAD_KEY_USER_AGENT = "User-Agent";
    public static final String HEAD_KEY_COOKIE = "Cookie";
    public static final String HEAD_KEY_SET_COOKIE = "Set-Cookie";

    public Headers() {
        super(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
    }

    public void setAll(Headers headers) {
        if (headers != null) {
            Set keySet = headers.keySet();
            for (String key : keySet) {
                this.set(key, headers.getValues(key));
            }
        }
    }

    public void addCookie(URI uri, CookieHandler cookieHandler) {
        try {
            Map<String, List<String>> diskCookies = cookieHandler.get(uri, new HashMap<String, List<String>>());
            for (Map.Entry<String, List<String>> entry : diskCookies.entrySet()) {
                String key = entry.getKey();
                List<String> value = entry.getValue();
                if (!HEAD_KEY_COOKIE.equalsIgnoreCase(key)) continue;
                this.add(key, TextUtils.join((CharSequence)"; ", value));
            }
        }
        catch (IOException e) {
            Logger.e(e);
        }
    }

    public void setJSONString(String jsonString) throws JSONException {
        this.clear();
        JSONObject jsonObject = new JSONObject(jsonString);
        Iterator keySet = jsonObject.keys();
        while (keySet.hasNext()) {
            String key = (String)keySet.next();
            String value = jsonObject.optString(key);
            JSONArray values = new JSONArray(value);
            for (int i = 0; i < values.length(); ++i) {
                this.add(key, values.optString(i));
            }
        }
    }

    public String toJSONString() {
        JSONObject jsonObject = new JSONObject();
        Set entrySet = this.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            List values = entry.getValue();
            JSONArray value = new JSONArray(values);
            try {
                jsonObject.put(key, (Object)value);
            }
            catch (JSONException e) {
                Logger.w(e);
            }
        }
        return jsonObject.toString();
    }

    public Map<String, String> toRequestHeaders() {
        LinkedHashMap<String, String> singleMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : this.entrySet()) {
            String key = (String)entry.getKey();
            List value = entry.getValue();
            String trueValue = TextUtils.join((CharSequence)"; ", value);
            singleMap.put(key, trueValue);
        }
        return singleMap;
    }

    public Map<String, List<String>> toResponseHeaders() {
        return this.getSource();
    }

    public List<HttpCookie> getCookies() {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        for (String key : this.keySet()) {
            if (!key.equalsIgnoreCase(HEAD_KEY_SET_COOKIE)) continue;
            List<String> cookieValues = this.getValues(key);
            for (String cookieStr : cookieValues) {
                for (HttpCookie cookie : HttpCookie.parse(cookieStr)) {
                    cookies.add(cookie);
                }
            }
        }
        return cookies;
    }

    public String getCacheControl() {
        List<String> cacheControls = this.getValues(HEAD_KEY_CACHE_CONTROL);
        if (cacheControls == null) {
            cacheControls = this.getValues(HEAD_KEY_PRAGMA);
        }
        if (cacheControls == null) {
            cacheControls = new ArrayList<String>();
        }
        return TextUtils.join((CharSequence)",", cacheControls);
    }

    public String getContentDisposition() {
        return (String)this.getValue(HEAD_KEY_CONTENT_DISPOSITION, 0);
    }

    public String getContentEncoding() {
        return (String)this.getValue(HEAD_KEY_CONTENT_ENCODING, 0);
    }

    public int getContentLength() {
        String contentLength = (String)this.getValue(HEAD_KEY_CONTENT_LENGTH, 0);
        try {
            return Integer.parseInt(contentLength);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public String getContentType() {
        return (String)this.getValue(HEAD_KEY_CONTENT_TYPE, 0);
    }

    public String getContentRange() {
        String contentRange = (String)this.getValue(HEAD_KEY_CONTENT_RANGE, 0);
        if (contentRange == null) {
            contentRange = (String)this.getValue(HEAD_KEY_ACCEPT_RANGE, 0);
        }
        return contentRange;
    }

    public long getDate() {
        return this.getDateField(HEAD_KEY_DATE);
    }

    public String getETag() {
        return (String)this.getValue(HEAD_KEY_E_TAG, 0);
    }

    public long getExpiration() {
        return this.getDateField(HEAD_KEY_EXPIRES);
    }

    public long getLastModified() {
        return this.getDateField(HEAD_KEY_LAST_MODIFIED);
    }

    public String getLocation() {
        return (String)this.getValue(HEAD_KEY_LOCATION, 0);
    }

    public int getResponseCode() {
        String responseCode = (String)this.getValue(HEAD_KEY_RESPONSE_CODE, 0);
        try {
            return Integer.parseInt(responseCode);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    private long getDateField(String key) {
        String value = (String)this.getValue(key, 0);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                return HeaderUtils.parseGMTToMillis(value);
            }
            catch (ParseException e) {
                Logger.w(e);
            }
        }
        return 0L;
    }

    @Override
    public boolean containsKey(String key) {
        return super.containsKey(key) || super.containsKey(key.toLowerCase());
    }

    @Override
    public List<String> getValues(String key) {
        List<String> strings = super.getValues(key);
        if (strings == null || strings.isEmpty()) {
            strings = super.getValues(key.toLowerCase());
        }
        return strings;
    }
}

