/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp;

import android.graphics.Bitmap;
import com.yodo1.nohttp.BasicBinary;
import com.yodo1.nohttp.tools.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapBinary
extends BasicBinary {
    private Bitmap mBitmap;

    public BitmapBinary(Bitmap bitmap, String fileName) {
        this(bitmap, fileName, null);
    }

    public BitmapBinary(Bitmap bitmap, String fileName, String mimeType) {
        super(fileName, mimeType);
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap is null: " + fileName);
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("Bitmap is recycled: " + fileName + ", bitmap must be not recycled.");
        }
        this.mBitmap = bitmap;
    }

    public static byte[] bitmap2ByteArray(Bitmap bitmap) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
        IOUtils.closeQuietly(outputStream);
        return outputStream.toByteArray();
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        if (this.mBitmap.isRecycled()) {
            return null;
        }
        return new ByteArrayInputStream(BitmapBinary.bitmap2ByteArray(this.mBitmap));
    }

    @Override
    public long getBinaryLength() {
        if (this.mBitmap.isRecycled()) {
            return 0L;
        }
        return BitmapBinary.bitmap2ByteArray(this.mBitmap).length;
    }
}

