/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp;

import android.text.TextUtils;
import com.yodo1.nohttp.Binary;
import com.yodo1.nohttp.FileBinary;
import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.Priority;
import com.yodo1.nohttp.RedirectHandler;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.UserAgent;
import com.yodo1.nohttp.able.Cancelable;
import com.yodo1.nohttp.able.Finishable;
import com.yodo1.nohttp.able.Startable;
import com.yodo1.nohttp.tools.CounterOutputStream;
import com.yodo1.nohttp.tools.HeaderUtils;
import com.yodo1.nohttp.tools.IOUtils;
import com.yodo1.nohttp.tools.LinkedMultiValueMap;
import com.yodo1.nohttp.tools.MultiValueMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.HttpCookie;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONObject;

public abstract class BasicRequest<T extends BasicRequest>
implements Comparable<BasicRequest>,
Startable,
Cancelable,
Finishable {
    private final String boundary = BasicRequest.createBoundary();
    private final String startBoundary = "--" + this.boundary;
    private final String endBoundary = this.startBoundary + "--";
    private Priority mPriority = Priority.DEFAULT;
    private int sequence;
    private String url;
    private RequestMethod mRequestMethod;
    private boolean isMultipartFormEnable = false;
    private Proxy mProxy;
    private SSLSocketFactory mSSLSocketFactory = NoHttp.getInitializeConfig().getSSLSocketFactory();
    private HostnameVerifier mHostnameVerifier = NoHttp.getInitializeConfig().getHostnameVerifier();
    private int mConnectTimeout = NoHttp.getInitializeConfig().getConnectTimeout();
    private int mReadTimeout = NoHttp.getInitializeConfig().getReadTimeout();
    private Headers mHeaders;
    private int mRetryCount = NoHttp.getInitializeConfig().getRetryCount();
    private String mParamEncoding;
    private MultiValueMap<String, Object> mParams;
    private InputStream mRequestBody;
    private RedirectHandler mRedirectHandler;
    private boolean isStart = false;
    private boolean isFinished = false;
    private boolean isCanceled = false;
    private WeakReference<Object> mCancelSign;
    private WeakReference<Object> mTag;

    public BasicRequest(String url) {
        this(url, RequestMethod.GET);
    }

    public BasicRequest(String url, RequestMethod requestMethod) {
        List<String> valueList;
        this.url = url;
        this.mRequestMethod = requestMethod;
        this.mHeaders = new Headers();
        this.mHeaders.set("Accept", "application/json,application/xml,application/xhtml+xml,text/html;q=0.9,image/webp,*/*;q=0.8");
        this.mHeaders.set("Accept-Encoding", "gzip, deflate");
        this.mHeaders.set("Accept-Language", HeaderUtils.systemAcceptLanguage());
        this.mHeaders.set("User-Agent", UserAgent.instance());
        MultiValueMap<String, String> globalHeaders = NoHttp.getInitializeConfig().getHeaders();
        for (Map.Entry<String, List<String>> headersEntry : globalHeaders.entrySet()) {
            String key = headersEntry.getKey();
            valueList = headersEntry.getValue();
            for (String value : valueList) {
                this.mHeaders.add(key, value);
            }
        }
        this.mParams = new LinkedMultiValueMap<String, Object>();
        MultiValueMap<String, String> globalParams = NoHttp.getInitializeConfig().getParams();
        for (Map.Entry<String, List<String>> paramsEntry : globalParams.entrySet()) {
            valueList = paramsEntry.getValue();
            for (String value : valueList) {
                this.mParams.add(paramsEntry.getKey(), value);
            }
        }
    }

    public static StringBuilder buildCommonParams(MultiValueMap<String, Object> paramMap, String encodeCharset) {
        StringBuilder paramBuilder = new StringBuilder();
        Set<String> keySet = paramMap.keySet();
        for (String key : keySet) {
            List<Object> values = paramMap.getValues(key);
            for (Object value : values) {
                if (value == null || !(value instanceof CharSequence)) continue;
                paramBuilder.append("&").append(key).append("=");
                try {
                    paramBuilder.append(URLEncoder.encode(value.toString(), encodeCharset));
                }
                catch (UnsupportedEncodingException e) {
                    Logger.e("Encoding " + encodeCharset + " format is not supported by the system.");
                    paramBuilder.append(value.toString());
                }
            }
        }
        if (paramBuilder.length() > 0) {
            paramBuilder.deleteCharAt(0);
        }
        return paramBuilder;
    }

    public static String createBoundary() {
        StringBuilder sb = new StringBuilder("----NoHttpFormBoundary");
        for (int t = 1; t < 12; ++t) {
            long time = System.currentTimeMillis() + (long)t;
            if (time % 3L == 0L) {
                sb.append((char)time % 9);
                continue;
            }
            if (time % 3L == 1L) {
                sb.append((char)(65L + time % 26L));
                continue;
            }
            sb.append((char)(97L + time % 26L));
        }
        return sb.toString();
    }

    public String url() {
        StringBuilder urlBuilder = new StringBuilder(this.url);
        if (this.hasDefineRequestBody()) {
            this.buildUrl(urlBuilder);
            return urlBuilder.toString();
        }
        if (this.getRequestMethod().allowRequestBody()) {
            return urlBuilder.toString();
        }
        this.buildUrl(urlBuilder);
        return urlBuilder.toString();
    }

    private void buildUrl(StringBuilder urlBuilder) {
        StringBuilder paramBuilder = BasicRequest.buildCommonParams(this.getParamKeyValues(), this.getParamsEncoding());
        if (paramBuilder.length() <= 0) {
            return;
        }
        if (this.url.contains("?") && this.url.contains("=")) {
            urlBuilder.append("&");
        } else if (!this.url.endsWith("?")) {
            urlBuilder.append("?");
        }
        urlBuilder.append((CharSequence)paramBuilder);
    }

    public RequestMethod getRequestMethod() {
        return this.mRequestMethod;
    }

    public T path(int value) {
        return this.path(Integer.toString(value));
    }

    public T path(long value) {
        return this.path(Long.toString(value));
    }

    public T path(boolean value) {
        return this.path(Boolean.toString(value));
    }

    public T path(char value) {
        return this.path(String.valueOf(value));
    }

    public T path(double value) {
        return this.path(Double.toString(value));
    }

    public T path(float value) {
        return this.path(Float.toString(value));
    }

    public T path(String value) {
        if (value != null) {
            if (!this.url.endsWith("/")) {
                this.url = this.url + "/";
            }
            this.url = this.url + value;
        }
        return (T)this;
    }

    public int getConnectTimeout() {
        return this.mConnectTimeout;
    }

    public T setConnectTimeout(int connectTimeout) {
        this.mConnectTimeout = connectTimeout;
        return (T)this;
    }

    public int getReadTimeout() {
        return this.mReadTimeout;
    }

    public T setReadTimeout(int readTimeout) {
        this.mReadTimeout = readTimeout;
        return (T)this;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.mSSLSocketFactory;
    }

    public T setSSLSocketFactory(SSLSocketFactory socketFactory) {
        this.mSSLSocketFactory = socketFactory;
        return (T)this;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.mHostnameVerifier;
    }

    public T setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.mHostnameVerifier = hostnameVerifier;
        return (T)this;
    }

    public Proxy getProxy() {
        return this.mProxy;
    }

    public T setProxy(Proxy proxy) {
        this.mProxy = proxy;
        return (T)this;
    }

    public RedirectHandler getRedirectHandler() {
        return this.mRedirectHandler;
    }

    public T setRedirectHandler(RedirectHandler redirectHandler) {
        this.mRedirectHandler = redirectHandler;
        return (T)this;
    }

    public int getRetryCount() {
        return this.mRetryCount;
    }

    public T setRetryCount(int count) {
        this.mRetryCount = count;
        return (T)this;
    }

    public T addHeader(String key, String value) {
        this.mHeaders.add(key, value);
        return (T)this;
    }

    public T setHeader(String key, String value) {
        this.mHeaders.set(key, value);
        return (T)this;
    }

    public T addHeader(HttpCookie cookie) {
        if (cookie != null) {
            this.mHeaders.add("Cookie", cookie.getName() + "=" + cookie.getValue());
        }
        return (T)this;
    }

    public T removeHeader(String key) {
        this.mHeaders.remove(key);
        return (T)this;
    }

    public T removeAllHeader() {
        this.mHeaders.clear();
        return (T)this;
    }

    public boolean containsHeader(String key) {
        return this.mHeaders.containsKey(key);
    }

    public Headers getHeaders() {
        return this.mHeaders;
    }

    public T setAccept(String accept) {
        this.mHeaders.set("Accept", accept);
        return (T)this;
    }

    public T setAcceptLanguage(String acceptLanguage) {
        this.mHeaders.set("Accept-Language", acceptLanguage);
        return (T)this;
    }

    public long getContentLength() {
        CounterOutputStream outputStream = new CounterOutputStream();
        try {
            this.onWriteRequestBody(outputStream);
        }
        catch (IOException e) {
            Logger.e(e);
        }
        return outputStream.get();
    }

    public String getContentType() {
        String contentType = (String)this.mHeaders.getValue("Content-Type", 0);
        if (!TextUtils.isEmpty((CharSequence)contentType)) {
            return contentType;
        }
        if (this.getRequestMethod().allowRequestBody() && this.isMultipartFormEnable()) {
            return "multipart/form-data; boundary=" + this.boundary;
        }
        return "application/x-www-form-urlencoded; charset=" + this.getParamsEncoding();
    }

    public T setContentType(String contentType) {
        this.mHeaders.set("Content-Type", contentType);
        return (T)this;
    }

    public T setUserAgent(String userAgent) {
        this.mHeaders.set("User-Agent", userAgent);
        return (T)this;
    }

    public String getParamsEncoding() {
        if (TextUtils.isEmpty((CharSequence)this.mParamEncoding)) {
            this.mParamEncoding = "utf-8";
        }
        return this.mParamEncoding;
    }

    public T setParamsEncoding(String encoding) {
        this.mParamEncoding = encoding;
        return (T)this;
    }

    public boolean isMultipartFormEnable() {
        return this.isMultipartFormEnable || this.hasBinary();
    }

    public T setMultipartFormEnable(boolean enable) {
        this.validateMethodForBody("Form body");
        this.isMultipartFormEnable = enable;
        return (T)this;
    }

    private boolean hasBinary() {
        Set<String> keys = this.mParams.keySet();
        for (String key : keys) {
            List<Object> values = this.mParams.getValues(key);
            for (Object value : values) {
                if (!(value instanceof Binary) && !(value instanceof File)) continue;
                return true;
            }
        }
        return false;
    }

    public T add(String key, int value) {
        this.mParams.add(key, Integer.toString(value));
        return (T)this;
    }

    public T add(String key, long value) {
        this.mParams.add(key, Long.toString(value));
        return (T)this;
    }

    public T add(String key, boolean value) {
        this.mParams.add(key, Boolean.toString(value));
        return (T)this;
    }

    public T add(String key, char value) {
        this.mParams.add(key, String.valueOf(value));
        return (T)this;
    }

    public T add(String key, double value) {
        this.mParams.add(key, Double.toString(value));
        return (T)this;
    }

    public T add(String key, float value) {
        this.mParams.add(key, Float.toString(value));
        return (T)this;
    }

    public T add(String key, short value) {
        this.mParams.add(key, Integer.toString(value));
        return (T)this;
    }

    public T add(String key, String value) {
        if (value != null) {
            this.mParams.add(key, value);
        }
        return (T)this;
    }

    public T set(String key, String value) {
        if (value != null) {
            this.mParams.set(key, value);
        }
        return (T)this;
    }

    private void validateMethodForBody(String methodObject) {
        if (!this.getRequestMethod().allowRequestBody()) {
            throw new IllegalArgumentException(methodObject + " only supports these request methods: POST/PUT/PATCH/DELETE.");
        }
    }

    public T add(String key, File file) {
        this.validateMethodForBody("The File param");
        this.mParams.add(key, new FileBinary(file));
        return (T)this;
    }

    public T add(String key, Binary binary) {
        this.validateMethodForBody("The Binary param");
        this.mParams.add(key, binary);
        return (T)this;
    }

    public T set(String key, Binary binary) {
        this.validateMethodForBody("The Binary param");
        this.mParams.set(key, binary);
        return (T)this;
    }

    public T add(String key, List<Binary> binaries) {
        this.validateMethodForBody("The List<Binary> param");
        for (Binary binary : binaries) {
            this.mParams.add(key, binary);
        }
        return (T)this;
    }

    public T set(String key, List<Binary> binaries) {
        this.validateMethodForBody("The List<Binary> param");
        this.mParams.remove(key);
        for (Binary binary : binaries) {
            this.mParams.add(key, binary);
        }
        return (T)this;
    }

    public T add(Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof File) {
                this.mParams.add(key, new FileBinary((File)value));
                continue;
            }
            if (value instanceof Binary) {
                this.mParams.add(key, value);
                continue;
            }
            if (value instanceof List) {
                List values = (List)value;
                for (int i = 0; i < values.size(); ++i) {
                    Object o = values.get(i);
                    if (o instanceof File) {
                        this.mParams.add(key, new FileBinary((File)o));
                        continue;
                    }
                    if (o instanceof Binary) {
                        this.mParams.add(key, value);
                        continue;
                    }
                    if (o == null) continue;
                    this.mParams.add(key, o.toString());
                }
                continue;
            }
            if (value == null) continue;
            this.mParams.add(key, value.toString());
        }
        return (T)this;
    }

    public T set(Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof File) {
                this.mParams.set(key, new FileBinary((File)value));
                continue;
            }
            if (value instanceof Binary) {
                this.mParams.set(key, value);
                continue;
            }
            if (value instanceof List) {
                this.mParams.remove(key);
                List values = (List)value;
                for (int i = 0; i < values.size(); ++i) {
                    Object o = values.get(i);
                    if (o instanceof File) {
                        this.mParams.add(key, new FileBinary((File)o));
                        continue;
                    }
                    if (o instanceof Binary) {
                        this.mParams.add(key, value);
                        continue;
                    }
                    if (o == null) continue;
                    this.mParams.add(key, o.toString());
                }
                continue;
            }
            if (value == null) continue;
            this.mParams.add(key, value.toString());
        }
        return (T)this;
    }

    public T remove(String key) {
        this.mParams.remove(key);
        return (T)this;
    }

    public T removeAll() {
        this.mParams.clear();
        return (T)this;
    }

    public MultiValueMap<String, Object> getParamKeyValues() {
        return this.mParams;
    }

    private void validateParamForBody(Object body, String contentType) {
        if (body == null || TextUtils.isEmpty((CharSequence)contentType)) {
            throw new NullPointerException("The requestBody and contentType must be can't be null");
        }
    }

    private boolean hasDefineRequestBody() {
        return this.mRequestBody != null;
    }

    public T setDefineRequestBody(InputStream requestBody, String contentType) {
        this.validateMethodForBody("Request body");
        this.validateParamForBody(requestBody, contentType);
        if (!(requestBody instanceof ByteArrayInputStream) && !(requestBody instanceof FileInputStream)) {
            throw new IllegalArgumentException("Can only accept ByteArrayInputStream and FileInputStream type of stream");
        }
        this.mRequestBody = requestBody;
        this.mHeaders.set("Content-Type", contentType);
        return (T)this;
    }

    public T setDefineRequestBody(String requestBody, String contentType) {
        this.validateMethodForBody("Request body");
        this.validateParamForBody(requestBody, contentType);
        try {
            this.mRequestBody = IOUtils.toInputStream(requestBody, this.getParamsEncoding());
            this.mHeaders.set("Content-Type", contentType + "; charset=" + this.getParamsEncoding());
        }
        catch (UnsupportedEncodingException e) {
            this.mRequestBody = IOUtils.toInputStream(requestBody);
            this.mHeaders.set("Content-Type", contentType);
        }
        return (T)this;
    }

    public T setDefineRequestBodyForJson(String jsonBody) {
        this.setDefineRequestBody(jsonBody, "application/json");
        return (T)this;
    }

    public T setDefineRequestBodyForJson(JSONObject jsonBody) {
        this.setDefineRequestBody(jsonBody.toString(), "application/json");
        return (T)this;
    }

    public T setDefineRequestBodyForXML(String xmlBody) {
        this.setDefineRequestBody(xmlBody, "application/xml");
        return (T)this;
    }

    public InputStream getDefineRequestBody() {
        return this.mRequestBody;
    }

    public void onPreExecute() {
    }

    public void onWriteRequestBody(OutputStream writer) throws IOException {
        if (this.hasDefineRequestBody()) {
            this.writeRequestBody(writer);
        } else if (this.isMultipartFormEnable()) {
            this.writeFormStreamData(writer);
        } else {
            this.writeParamStreamData(writer);
        }
    }

    private void writeRequestBody(OutputStream writer) throws IOException {
        if (this.mRequestBody != null) {
            if (writer instanceof CounterOutputStream) {
                ((CounterOutputStream)writer).writeLength(this.mRequestBody.available());
            } else {
                IOUtils.write(this.mRequestBody, writer);
                IOUtils.closeQuietly(this.mRequestBody);
                this.mRequestBody = null;
            }
        }
    }

    private void writeFormStreamData(OutputStream writer) throws IOException {
        if (this.isCanceled()) {
            return;
        }
        Set<String> keys = this.mParams.keySet();
        for (String key : keys) {
            List<Object> values = this.mParams.getValues(key);
            for (Object value : values) {
                if (value != null && value instanceof String) {
                    if (!(writer instanceof CounterOutputStream)) {
                        Logger.i(key + "=" + value);
                    }
                    this.writeFormString(writer, key, (String)value);
                } else if (value != null && value instanceof Binary) {
                    if (!(writer instanceof CounterOutputStream)) {
                        Logger.i(key + " is Binary");
                    }
                    this.writeFormBinary(writer, key, (Binary)value);
                }
                writer.write("\r\n".getBytes());
            }
        }
        writer.write(this.endBoundary.getBytes());
    }

    private void writeFormString(OutputStream writer, String key, String value) throws IOException {
        String stringFieldBuilder = this.startBoundary + "\r\nContent-Disposition: form-data; name=\"" + key + "\"\r\n\r\n";
        writer.write(stringFieldBuilder.getBytes(this.getParamsEncoding()));
        writer.write(value.getBytes(this.getParamsEncoding()));
    }

    private void writeFormBinary(OutputStream writer, String key, Binary value) throws IOException {
        String binaryFieldBuilder = this.startBoundary + "\r\nContent-Disposition: form-data; name=\"" + key + "\"; filename=\"" + value.getFileName() + "\"\r\nContent-Type: " + value.getMimeType() + "\r\n\r\n";
        writer.write(binaryFieldBuilder.getBytes());
        if (writer instanceof CounterOutputStream) {
            ((CounterOutputStream)writer).writeLength(value.getLength());
        } else {
            value.onWriteBinary(writer);
        }
    }

    private void writeParamStreamData(OutputStream writer) throws IOException {
        StringBuilder paramBuilder = BasicRequest.buildCommonParams(this.mParams, this.getParamsEncoding());
        if (paramBuilder.length() > 0) {
            String params = paramBuilder.toString();
            if (!(writer instanceof CounterOutputStream)) {
                Logger.i("Body: " + params);
            }
            IOUtils.write(params.getBytes(), writer);
        }
    }

    public Object getTag() {
        return this.mTag;
    }

    public T setTag(Object tag) {
        this.mTag = new WeakReference<Object>(tag);
        return (T)this;
    }

    public Priority getPriority() {
        return this.mPriority;
    }

    public T setPriority(Priority priority) {
        this.mPriority = priority;
        return (T)this;
    }

    public int getSequence() {
        return this.sequence;
    }

    public T setSequence(int sequence) {
        this.sequence = sequence;
        return (T)this;
    }

    @Override
    public final int compareTo(BasicRequest another) {
        Priority it;
        Priority me = this.getPriority();
        return me == (it = another.getPriority()) ? this.getSequence() - another.getSequence() : it.ordinal() - me.ordinal();
    }

    @Override
    public void start() {
        this.isStart = true;
    }

    @Override
    public boolean isStarted() {
        return this.isStart;
    }

    @Override
    public void cancel() {
        if (!this.isCanceled) {
            this.isCanceled = true;
            if (this.mRequestBody != null) {
                IOUtils.closeQuietly(this.mRequestBody);
            }
            Set<String> keys = this.mParams.keySet();
            for (String key : keys) {
                List<Object> values = this.mParams.getValues(key);
                for (Object value : values) {
                    if (value == null || !(value instanceof Binary)) continue;
                    ((Binary)value).cancel();
                }
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void finish() {
        this.isFinished = true;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    public T setCancelSign(Object sign) {
        this.mCancelSign = new WeakReference<Object>(sign);
        return (T)this;
    }

    public void cancelBySign(Object sign) {
        Object meSign = null;
        if (this.mCancelSign != null) {
            meSign = this.mCancelSign.get();
        }
        if (this.mCancelSign == meSign || sign != null && meSign != null && meSign.equals(sign)) {
            this.cancel();
        }
    }
}

