/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.nohttp;

import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.yodo1.nohttp.Binary;
import com.yodo1.nohttp.HandlerDelivery;
import com.yodo1.nohttp.Logger;
import com.yodo1.nohttp.OnUploadListener;
import com.yodo1.nohttp.able.Finishable;
import com.yodo1.nohttp.able.Startable;
import com.yodo1.nohttp.tools.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BasicBinary
implements Binary,
Startable,
Finishable {
    private boolean isStarted = false;
    private boolean isCancel = false;
    private boolean isFinish = false;
    private int what;
    private OnUploadListener mUploadListener;
    private String fileName;
    private String mimeType;

    public BasicBinary(String fileName, String mimeType) {
        this.fileName = fileName;
        this.mimeType = mimeType;
    }

    public void setUploadListener(int what, OnUploadListener mProgressHandler) {
        this.what = what;
        this.mUploadListener = mProgressHandler;
    }

    @Override
    public final long getLength() {
        if (!this.isCanceled()) {
            return this.getBinaryLength();
        }
        return 0L;
    }

    public abstract long getBinaryLength();

    protected abstract InputStream getInputStream() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWriteBinary(OutputStream outputStream) {
        if (!this.isCanceled()) {
            InputStream inputStream = null;
            try {
                int len;
                inputStream = this.getInputStream();
                if (inputStream == null) {
                    return;
                }
                inputStream = IOUtils.toBufferedInputStream(inputStream);
                this.start();
                this.postStart();
                int oldProgress = 0;
                long totalLength = this.getLength();
                byte[] buffer = new byte[4096];
                long hasUpCount = 0L;
                while (!this.isCanceled() && (len = inputStream.read(buffer)) != -1) {
                    int progress;
                    outputStream.write(buffer, 0, len);
                    if (totalLength == 0L || this.mUploadListener == null || 0 != (progress = (int)((hasUpCount += (long)len) * 100L / totalLength)) % 3 && 0 != progress % 5 && 0 != progress % 7 || oldProgress == progress) continue;
                    oldProgress = progress;
                    this.postProgress(oldProgress);
                }
            }
            catch (Exception e) {
                Logger.e(e);
                this.postError(e);
            }
            finally {
                IOUtils.closeQuietly(inputStream);
                this.postFinish();
            }
        }
        this.finish();
    }

    @Override
    public String getFileName() {
        if (TextUtils.isEmpty((CharSequence)this.fileName)) {
            this.fileName = Long.toString(System.currentTimeMillis());
        }
        return this.fileName;
    }

    @Override
    public String getMimeType() {
        String fileName = this.getFileName();
        if (TextUtils.isEmpty((CharSequence)this.mimeType) && !TextUtils.isEmpty((CharSequence)fileName)) {
            String extension = MimeTypeMap.getFileExtensionFromUrl((String)fileName);
            this.mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        if (TextUtils.isEmpty((CharSequence)this.mimeType)) {
            this.mimeType = "application/octet-stream";
        }
        return this.mimeType;
    }

    protected void postStart() {
        UploadPoster start = new UploadPoster(this.what, this.mUploadListener);
        start.start();
        HandlerDelivery.getInstance().post(start);
    }

    protected void postProgress(int progress) {
        UploadPoster progressPoster = new UploadPoster(this.what, this.mUploadListener);
        progressPoster.progress(progress);
        HandlerDelivery.getInstance().post(progressPoster);
    }

    protected void postCancel() {
        UploadPoster cancelPoster = new UploadPoster(this.what, this.mUploadListener);
        cancelPoster.cancel();
        HandlerDelivery.getInstance().post(cancelPoster);
    }

    protected void postError(Exception e) {
        UploadPoster error = new UploadPoster(this.what, this.mUploadListener);
        error.error(e);
        HandlerDelivery.getInstance().post(error);
    }

    protected void postFinish() {
        UploadPoster finish = new UploadPoster(this.what, this.mUploadListener);
        finish.finish();
        HandlerDelivery.getInstance().post(finish);
    }

    @Override
    public void start() {
        this.isStarted = true;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public void cancel() {
        if (!this.isCancel) {
            this.isCancel = true;
            this.postCancel();
        }
    }

    @Override
    public boolean isCanceled() {
        return this.isCancel;
    }

    @Override
    public void finish() {
        this.isFinish = true;
    }

    @Override
    public boolean isFinished() {
        return this.isFinish;
    }

    private class UploadPoster
    implements Runnable {
        static final int ON_START = 0;
        static final int ON_CANCEL = 1;
        static final int ON_PROGRESS = 2;
        static final int ON_FINISH = 3;
        static final int ON_ERROR = 4;
        private final int what;
        private final OnUploadListener mOnUploadListener;
        private int command;
        private int progress;
        private Exception exception;

        public UploadPoster(int what, OnUploadListener onUploadListener) {
            this.what = what;
            this.mOnUploadListener = onUploadListener;
        }

        public void start() {
            this.command = 0;
        }

        public void cancel() {
            this.command = 1;
        }

        public void progress(int progress) {
            this.command = 2;
            this.progress = progress;
        }

        public void finish() {
            this.command = 3;
        }

        public void error(Exception exception) {
            this.command = 4;
            this.exception = exception;
        }

        @Override
        public void run() {
            if (this.mOnUploadListener != null) {
                if (this.command == 0) {
                    this.mOnUploadListener.onStart(this.what);
                } else if (this.command == 3) {
                    this.mOnUploadListener.onFinish(this.what);
                } else if (this.command == 2) {
                    this.mOnUploadListener.onProgress(this.what, this.progress);
                } else if (this.command == 1) {
                    this.mOnUploadListener.onCancel(this.what);
                } else if (this.command == 4) {
                    this.mOnUploadListener.onError(this.what, this.exception);
                }
            }
        }
    }
}

