/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.android.ops.net;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.yodo1.android.ops.net.HttpListener;
import com.yodo1.android.ops.net.HttpResponseListener;
import com.yodo1.android.ops.net.Yodo1SDKResponse;
import com.yodo1.nohttp.InitializationConfig;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.URLConnectionNetworkExecutor;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.RequestQueue;
import com.yodo1.nohttp.rest.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class Yodo1HttpManage {
    private static Yodo1HttpManage instance;
    private static Context mainActivity;
    private Object object = new Object();
    private RequestQueue mQueue;
    private boolean isInit = false;

    public static Yodo1HttpManage getInstance() {
        if (instance == null) {
            instance = new Yodo1HttpManage();
        }
        return instance;
    }

    public void initHttp(Context activity) {
        if (!this.isInit) {
            mainActivity = activity;
            Log.d((String)"yodo1-games-sdk", (String)"Yodo1HttpManageInit");
            NoHttp.initialize(InitializationConfig.newBuilder(activity).connectionTimeout(30000).readTimeout(30000).networkExecutor(new URLConnectionNetworkExecutor()).build());
            this.mQueue = NoHttp.newRequestQueue(1);
            this.isInit = true;
        }
    }

    public <T> void connect(final int what, final Request<T> request, final HttpListener<T> callback, boolean isLoading) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Yodo1HttpManage.this.mQueue.add(what, request, new HttpResponseListener(mainActivity, request, callback));
            }
        });
    }

    public Yodo1SDKResponse getResponseObject(int requestType, Response<String> response) {
        boolean isSuccess = false;
        int errorCode = 0;
        String message = null;
        JSONObject jsonData = null;
        String data = response.get();
        if (TextUtils.isEmpty((CharSequence)data)) {
            isSuccess = false;
            errorCode = 10102;
        } else {
            try {
                JSONObject obj = new JSONObject(data);
                if (obj.optInt("error_code") != 0) {
                    isSuccess = false;
                    errorCode = obj.getInt("error_code");
                    message = obj.optString("error_msg");
                } else {
                    isSuccess = true;
                    jsonData = new JSONObject(data);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                isSuccess = false;
                errorCode = 10102;
            }
        }
        Yodo1SDKResponse responseObject = new Yodo1SDKResponse(requestType, isSuccess, errorCode);
        responseObject.setRawData(data);
        responseObject.setMessage(message);
        if (isSuccess) {
            responseObject.setResponse(jsonData);
        }
        return responseObject;
    }

    public void onDestroy() {
        this.mQueue.cancelBySign(this.object);
        this.mQueue.stop();
    }
}

